/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DomRead {
    static Document document;
    private int interfaceNo = 0;
    private int volume = 64;
    private Hashtable portTable;
    private int portMax = 0;
    private int instOffset = 0;
    public static Integer DEFAULT;
    public static final int VOLUME = 0;
    public static final int DURATION = 1;
    public static final int INST = 2;
    HostCollection srcIgnoreHostsTCP = new HostCollection();
    HostCollection dstIgnoreHostsTCP = new HostCollection();
    HostCollection srcIgnoreHostsUDP = new HostCollection();
    HostCollection dstIgnoreHostsUDP = new HostCollection();

    public static void main(String[] stringArray) {
        if (stringArray.length != 1) {
            System.err.println("Usage: java DomRead filename");
            System.exit(1);
        }
        DomRead domRead = new DomRead();
        domRead.read(stringArray[0]);
        System.out.println("Interface:" + domRead.getInterfaceNo());
        System.out.println("Volume:" + domRead.getVolume());
        System.out.println("InstOff:" + domRead.getInstOffset());
        int[][][] nArray = domRead.getTable();
        int n = 0;
        while (n < nArray.length) {
            int[][] nArray2 = nArray[n];
            if (nArray2 != null) {
                System.out.println("port:" + n + " inst:" + nArray2[2][0]);
                int n2 = 0;
                while (nArray2[1] != null && n2 < nArray2[1].length) {
                    System.out.print(nArray2[1][n2] + ", ");
                    ++n2;
                }
                System.out.println(":duration");
                int n3 = 0;
                while (nArray2[0] != null && n3 < nArray2[0].length) {
                    System.out.print(nArray2[0][n3] + ", ");
                    ++n3;
                }
                System.out.println(":Volume");
            }
            ++n;
        }
    }

    public void read(String string) {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            try {
                document = documentBuilder.parse(new File(string));
            }
            catch (Exception exception) {
                document = documentBuilder.parse(string);
            }
            this.portTable = new Hashtable();
            this.portMax = 0;
            Element element = document.getDocumentElement();
            NamedNodeMap namedNodeMap = element.getAttributes();
            Node node = namedNodeMap.getNamedItem("interface");
            if (node != null) {
                this.interfaceNo = Integer.valueOf(node.getNodeValue());
                System.out.println(node.getNodeName() + "=" + node.getNodeValue());
            }
            if ((node = namedNodeMap.getNamedItem("volume")) != null) {
                this.volume = Integer.valueOf(node.getNodeValue());
                System.out.println(node.getNodeName() + "=" + node.getNodeValue());
            }
            NodeList nodeList = element.getChildNodes();
            int n = 0;
            while (n < nodeList.getLength()) {
                node = nodeList.item(n);
                if (node.getNodeName().equals("map")) {
                    this.parseMap(node);
                } else if (node.getNodeName().equals("ignore")) {
                    this.parseIgnore(node);
                }
                ++n;
            }
        }
        catch (SAXException sAXException) {
            Exception exception = sAXException;
            if (sAXException.getException() != null) {
                exception = sAXException.getException();
            }
            exception.printStackTrace();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    protected void parseMap(Node node) {
        Integer n = null;
        int[][] nArrayArray = new int[3][];
        try {
            NamedNodeMap namedNodeMap = node.getAttributes();
            Node node2 = namedNodeMap.getNamedItem("port");
            if (node2.getNodeValue().equals("default")) {
                n = DEFAULT;
                node2 = namedNodeMap.getNamedItem("inst-offset");
                if (node2 != null) {
                    nArrayArray[2] = new int[1];
                    nArrayArray[2][0] = Integer.valueOf(node2.getNodeValue());
                }
            } else {
                n = Integer.valueOf(node2.getNodeValue());
                if (n > this.portMax) {
                    this.portMax = n;
                }
                if ((node2 = namedNodeMap.getNamedItem("inst")) != null) {
                    nArrayArray[2] = new int[1];
                    nArrayArray[2][0] = node2.getNodeValue().startsWith("i") || node2.getNodeValue().startsWith("I") ? -1 : Integer.valueOf(node2.getNodeValue());
                }
            }
            NodeList nodeList = node.getChildNodes();
            int n2 = 0;
            while (n2 < nodeList.getLength()) {
                node2 = nodeList.item(n2);
                if (node2.getNodeName().equals("durations")) {
                    if (node2.hasChildNodes()) {
                        node2 = node2.getChildNodes().item(0);
                        nArrayArray[1] = this.parseCSV(node2.getNodeValue());
                        System.out.println(node2.getNodeName() + "=" + node2.getNodeValue());
                    }
                } else if (node2.getNodeName().equals("volumes") && node2.hasChildNodes()) {
                    node2 = node2.getChildNodes().item(0);
                    nArrayArray[0] = this.parseCSV(node2.getNodeValue());
                    System.out.println(node2.getNodeName() + "=" + node2.getNodeValue());
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            System.err.println("Parse Error");
            exception.printStackTrace();
        }
        if (n != null) {
            this.portTable.put(n, nArrayArray);
        }
    }

    public int[] parseCSV(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        int[] nArray = new int[stringTokenizer.countTokens()];
        int n = 0;
        while (n < nArray.length) {
            nArray[n] = Integer.valueOf(stringTokenizer.nextToken());
            ++n;
        }
        return nArray;
    }

    protected void parseIgnore(Node node) {
        try {
            NamedNodeMap namedNodeMap = node.getAttributes();
            Node node2 = namedNodeMap.getNamedItem("host");
            Node node3 = namedNodeMap.getNamedItem("type");
            Node node4 = namedNodeMap.getNamedItem("port");
            Node node5 = namedNodeMap.getNamedItem("protocol");
            int n = -1;
            try {
                n = Integer.valueOf(node4.getNodeValue());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (node3 == null || node3.getNodeValue().equals("src") || node3.getNodeValue().equals("both")) {
                if (node5 == null || node5.getNodeValue().equals("TCP")) {
                    this.srcIgnoreHostsTCP.add(node2.getNodeValue(), n);
                    System.err.println("Ignore TCP SRC " + node2.getNodeValue() + ":" + n);
                }
                if (node5 == null || node5.getNodeValue().equals("UDP")) {
                    this.srcIgnoreHostsUDP.add(node2.getNodeValue(), n);
                    System.err.println("Ignore UDP SRC " + node2.getNodeValue() + ":" + n);
                }
            }
            if (node3 == null || node3.getNodeValue().equals("dst") || node3.getNodeValue().equals("both")) {
                if (node5 == null || node5.getNodeValue().equals("TCP")) {
                    this.dstIgnoreHostsTCP.add(node2.getNodeValue(), n);
                    System.err.println("Ignore TCP DST " + node2.getNodeValue() + ":" + n);
                }
                if (node5 == null || node5.getNodeValue().equals("UDP")) {
                    this.dstIgnoreHostsUDP.add(node2.getNodeValue(), n);
                    System.err.println("Ignore UDP DST " + node2.getNodeValue() + ":" + n);
                }
            }
        }
        catch (Exception exception) {
            System.err.println("Parse Error");
            exception.printStackTrace();
        }
    }

    public int getInterfaceNo() {
        return this.interfaceNo;
    }

    public int getVolume() {
        return this.volume;
    }

    public int getInstOffset() {
        return ((int[][])this.portTable.get(DEFAULT))[2][0];
    }

    public int[][][] getTable() {
        int[][][] nArrayArray = new int[this.portMax + 1][][];
        Enumeration enumeration = this.portTable.keys();
        while (enumeration.hasMoreElements()) {
            Integer n = (Integer)enumeration.nextElement();
            nArrayArray[n.intValue()] = (int[][])this.portTable.get(n);
        }
        return nArrayArray;
    }

    static {
        DEFAULT = new Integer(0);
    }
}

