/*
 * Decompiled with CFR 0.152.
 */
import javax.sound.midi.Instrument;
import javax.sound.midi.MidiChannel;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.Soundbank;
import javax.sound.midi.Synthesizer;
import jpcap.IPPacket;
import jpcap.TCPPacket;
import jpcap.UDPPacket;

public class pbLChannelDom
extends pbListenerDom {
    int[][][] data = null;
    HostCollection srcIgnoreHostsTCP;
    HostCollection dstIgnoreHostsTCP;
    HostCollection srcIgnoreHostsUDP;
    HostCollection dstIgnoreHostsUDP;
    static MidiChannel channel = null;
    private boolean playing = false;
    int duration = 128;
    int vel = 64;
    public static final int MusicBox = 10;
    public static final int TubularBells = 14;
    public static final int TinkleBell = 112;
    public static final int TelephoneRing = 124;
    static int inst = 112;
    static int basePitch = 64;
    static int widthPitch = 32;

    public void initialize() {
        block3: {
            try {
                Synthesizer synthesizer = MidiSystem.getSynthesizer();
                synthesizer.open();
                Soundbank soundbank = synthesizer.getDefaultSoundbank();
                Instrument[] instrumentArray = synthesizer.getDefaultSoundbank().getInstruments();
                synthesizer.loadInstrument(instrumentArray[0]);
                channel = synthesizer.getChannels()[0];
            }
            catch (Exception exception) {
                exception.printStackTrace();
                if (channel == null) break block3;
                channel.allNotesOff();
            }
        }
        if (channel != null) {
            System.out.println("intiMIDI Channel NON null");
            return;
        }
        System.out.println("intiMIDI Channel NULL");
    }

    public void set(DomRead domRead) {
        this.data = domRead.getTable();
        if (this.data[0] == null) {
            this.data[0] = new int[3][];
        }
        if (this.data[0][0] == null) {
            this.data[0][0] = new int[]{64, 75, 90};
        }
        if (this.data[0][1] == null) {
            this.data[0][1] = new int[]{64, 64, 64, 128, 128, 128, 128, 256};
        }
        if (this.data[0][2] == null) {
            this.data[0][2] = new int[]{0};
        }
        this.srcIgnoreHostsTCP = domRead.srcIgnoreHostsTCP;
        this.dstIgnoreHostsTCP = domRead.dstIgnoreHostsTCP;
        this.srcIgnoreHostsUDP = domRead.srcIgnoreHostsUDP;
        this.dstIgnoreHostsUDP = domRead.dstIgnoreHostsUDP;
    }

    protected void handlePacket(IPPacket iPPacket) {
        try {
            Object object;
            if (this.playing || iPPacket.data.length == 0) {
                return;
            }
            int n = 0;
            try {
                TCPPacket tCPPacket = (TCPPacket)iPPacket;
                n = tCPPacket.src_port;
                if (this.srcIgnoreHostsTCP.check(tCPPacket.src_ip.getAddress(), tCPPacket.src_port) || this.dstIgnoreHostsTCP.check(tCPPacket.dst_ip.getAddress(), tCPPacket.dst_port)) {
                    System.out.println("Ignore:" + iPPacket);
                    return;
                }
                if (n > tCPPacket.dst_port) {
                    n = tCPPacket.dst_port;
                }
                inst = this.data[n %= this.data.length] != null && this.data[n][2] != null ? this.data[n][2][0] : (n + this.data[0][2][0]) % 128;
            }
            catch (ClassCastException classCastException) {
                try {
                    object = (UDPPacket)iPPacket;
                    if (this.srcIgnoreHostsUDP.check(object.src_ip.getAddress(), object.src_port) || this.dstIgnoreHostsUDP.check(object.dst_ip.getAddress(), object.dst_port)) {
                        System.out.println("Ignore:" + iPPacket);
                        return;
                    }
                    n = object.src_port;
                    if (n > ((UDPPacket)iPPacket).dst_port) {
                        n = ((UDPPacket)iPPacket).dst_port;
                    }
                    inst = this.data[n %= this.data.length] != null && this.data[n][2] != null ? this.data[n][2][0] : (n + this.data[0][2][0]) % 128;
                }
                catch (ClassCastException classCastException2) {
                    // empty catch block
                }
            }
            this.playing = true;
            int n2 = iPPacket.data[iPPacket.data.length / 2] % widthPitch + basePitch;
            if (iPPacket.data.length > 0) {
                object = null;
                if (this.data[n] != null) {
                    object = this.data[n][1];
                }
                if (object == null) {
                    object = this.data[0][1];
                }
                this.duration = (int)object[(128 + iPPacket.data[iPPacket.data.length / 2]) % ((UDPPacket)object).length];
            }
            if (iPPacket.data.length > 1) {
                object = null;
                if (this.data[n] != null) {
                    object = this.data[n][0];
                }
                if (object == null) {
                    object = this.data[0][0];
                }
                this.vel = (int)object[(128 + iPPacket.data[iPPacket.data.length / 2 - 1]) % ((UDPPacket)object).length];
            }
            System.out.println("i:" + inst + " p:" + n2 + " v:" + this.vel + " d:" + this.duration + ":" + iPPacket.toString());
            if (inst > -1) {
                channel.programChange(inst);
                channel.noteOn(n2, this.vel);
                Thread.currentThread();
                Thread.sleep(this.duration);
                channel.noteOff(n2, this.vel);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.playing = false;
    }
}

