/*
 * Decompiled with CFR 0.152.
 */
import javax.sound.midi.Instrument;
import javax.sound.midi.MidiChannel;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.Soundbank;
import javax.sound.midi.Synthesizer;
import jpcap.IPPacket;
import jpcap.TCPPacket;
import jpcap.UDPPacket;

public class pbLChannelInst
extends pbListener {
    static MidiChannel channel = null;
    private boolean playing = false;
    private static int[] vels = new int[]{64, 75, 90};
    private static int[] durs = new int[]{64, 64, 64, 128, 128, 128, 128, 256, 512, 1024};
    int vel = vels[0];
    int duration = durs[1];
    public static final int MusicBox = 10;
    public static final int TubularBells = 14;
    public static final int TinkleBell = 112;
    public static final int TelephoneRing = 124;
    static int inst = 112;
    static int basePitch = 64;
    static int widthPitch = 32;

    public void initialize() {
        block3: {
            try {
                Synthesizer synthesizer = MidiSystem.getSynthesizer();
                synthesizer.open();
                Soundbank soundbank = synthesizer.getDefaultSoundbank();
                Instrument[] instrumentArray = synthesizer.getDefaultSoundbank().getInstruments();
                synthesizer.loadInstrument(instrumentArray[0]);
                channel = synthesizer.getChannels()[0];
            }
            catch (Exception exception) {
                exception.printStackTrace();
                if (channel == null) break block3;
                channel.allNotesOff();
            }
        }
        if (channel != null) {
            System.out.println("intiMIDI Channel NON null");
            return;
        }
        System.out.println("intiMIDI Channel NULL");
    }

    protected void handlePacket(IPPacket iPPacket) {
        try {
            int n;
            if (this.playing || iPPacket.data.length == 0) {
                return;
            }
            this.playing = true;
            try {
                n = ((TCPPacket)iPPacket).src_port;
                if (n > ((TCPPacket)iPPacket).dst_port) {
                    n = ((TCPPacket)iPPacket).dst_port;
                }
                inst = (n + 32) % 128;
            }
            catch (ClassCastException classCastException) {
                try {
                    int n2 = ((UDPPacket)iPPacket).src_port;
                    if (n2 > ((UDPPacket)iPPacket).dst_port) {
                        n2 = ((UDPPacket)iPPacket).dst_port;
                    }
                    inst = n2 % 128;
                }
                catch (ClassCastException classCastException2) {
                    // empty catch block
                }
            }
            n = iPPacket.data[iPPacket.data.length / 2] % widthPitch + basePitch;
            if (iPPacket.data.length > 0) {
                this.duration = durs[(128 + iPPacket.data[iPPacket.data.length / 2 + 1]) % durs.length];
            }
            if (iPPacket.data.length > 1) {
                this.vel = vels[(128 + iPPacket.data[iPPacket.data.length / 2 - 1]) % vels.length];
            }
            System.out.println("pitch:" + n + " v:" + this.vel + " d:" + this.duration + ":" + iPPacket.toString());
            channel.programChange(inst);
            channel.noteOn(n, this.vel);
            Thread.currentThread();
            Thread.sleep(this.duration);
            channel.noteOff(n, this.vel);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.playing = false;
    }
}

