/*
 * Decompiled with CFR 0.152.
 */
import javax.sound.midi.MetaEventListener;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.Sequence;
import javax.sound.midi.Sequencer;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.Track;
import jpcap.IPPacket;

public class pbLSequence
extends pbListener
implements MetaEventListener {
    int[][] notes = new int[32][3];
    private static final int PITCH = 0;
    private static final int VEL = 1;
    private static final int DUR = 2;
    public static final int Vibraphone = 11;
    public static final int Marimba = 12;
    public static final int Xylophone = 13;
    int instrument = 11;
    int basePitch = 54;
    int pitchIndex = 0;
    Sequencer sequencer;
    Sequence sequence = null;
    boolean dirty = true;
    private static int baseVel = 80;

    public pbLSequence() {
        int n = 0;
        while (n < this.notes.length) {
            this.notes[n][0] = this.basePitch - this.notes.length / 2 + n % 24;
            this.notes[n][1] = baseVel - 24 + 24 * (n / 4 % 3);
            this.notes[n][2] = 1;
            ++n;
        }
    }

    protected void handlePacket(IPPacket iPPacket) {
        System.out.println(iPPacket.toString());
        int n = iPPacket.data.length;
        if (n < 1) {
            return;
        }
        this.notes[this.pitchIndex][0] = this.basePitch + iPPacket.data[n / 2] % 12;
        this.notes[this.pitchIndex][1] = baseVel;
        if (n > 1) {
            int[] nArray = this.notes[this.pitchIndex];
            nArray[1] = nArray[1] + 24 * iPPacket.data[n / 2 - 1] % 2;
        }
        this.notes[this.pitchIndex][2] = 1;
        ++this.pitchIndex;
        this.pitchIndex %= this.notes.length;
        this.dirty = true;
    }

    protected void updateSequence() {
        try {
            int n = 0;
            Sequence sequence = new Sequence(0.0f, 24);
            Track track = sequence.createTrack();
            MetaMessage metaMessage = new MetaMessage();
            int n2 = 20;
            int n3 = 60000000 / n2;
            metaMessage.setMessage(81, new byte[]{(byte)(n3 / 65536), (byte)(n3 % 65536 / 256), (byte)(n3 % 256)}, 3);
            track.add(new MidiEvent(metaMessage, 0L));
            ShortMessage shortMessage = new ShortMessage();
            shortMessage.setMessage(192, n, this.instrument, 0);
            track.add(new MidiEvent(shortMessage, 0L));
            int n4 = 0;
            int n5 = 0;
            while (n5 < this.notes.length && this.notes[n5][0] > 0) {
                shortMessage = new ShortMessage();
                shortMessage.setMessage(144, n, this.notes[n5][0], this.notes[n5][1]);
                track.add(new MidiEvent(shortMessage, n4));
                shortMessage = new ShortMessage();
                shortMessage.setMessage(128, n, this.notes[n5][0], this.notes[n5][1]);
                track.add(new MidiEvent(shortMessage, n4 += this.notes[n5][2]));
                ++n5;
            }
            this.sequence = sequence;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void initialize() {
        try {
            this.sequencer = MidiSystem.getSequencer();
            this.sequencer.addMetaEventListener(this);
            this.sequencer.open();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.start();
    }

    public void start() {
        if (this.dirty) {
            this.updateSequence();
        }
        this.dirty = false;
        try {
            this.sequencer.setSequence(this.sequence);
            this.sequencer.start();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void stop() {
        this.sequence = null;
        this.sequencer.stop();
    }

    public void meta(MetaMessage metaMessage) {
        if (this.sequence != null) {
            this.start();
        }
    }
}

