<?php
class simplate
{
  var $bl = array();
  var $bl_idx;
  var $p_bl = array();
  var $ipp = array();
  var $src = array();
  var $dat = array();
  var $html_content = '';

  function simplate($fname) {
    $this->bl["_ROOT"] = array();
    $htmlTextLines = file($fname);

    $inc_pattern = '/<!--\s*INCLUDE\s*(.*?)\s*-->/';
    $htmlTextNew = array();
    foreach($htmlTextLines as $htmlText) {
      while(preg_match($inc_pattern, $htmlText, $match)) {
        $inc_tpl_path = dirname($fname)."/{$match[1]}";
        if (file_exists($inc_tpl_path)) {
          $inc_text = file_get_contents($inc_tpl_path);
          $htmlText = str_replace($match[0], $inc_text, $htmlText);
        } else {
          $htmlText = str_replace($match[0], '', $htmlText);
        }
      }
      $htmlTextNew[] = $htmlText;
    }

    $this->dat["src"] = $htmlTextNew;
    $this->dat["size"] = count($this->dat["src"]);
    $bl_info["vpp"] = 0;
    $bl_info["cpp"] = 0;
    $bl_info["ipp"] = 0;
    $this->parse("_ROOT", $bl_info);
    $this->ipp["_ROOT"] = 0;
    $this->src["_ROOT_0" ][0] = array("_ROOT");
    $this->bl_idx = &$this->src["_ROOT_0"][0];
    unset($this->dat);
  }

  function parse($bl_name, $bl_info) {
    $cpp = $bl_info["cpp"];
    $vpp = $bl_info["vpp"];
    $ipp = $bl_info["ipp"];

    while($ipp < $this->dat["size"]) {
      if(preg_match('/<!--\s*(START|END)\s+(.*?)\s*-->/', $this->dat["src"][$ipp], $match)) {
        $tmp_bl_name = trim($match[2]);
        if($tmp_bl_name == $bl_name) {
           break;
        } else {
          $this->bl[$tmp_bl_name] = array();
          $this->bl[$bl_name]["-a,". $tmp_bl_name] = '';
          $this->ipp[$tmp_bl_name]  = 0;
          $this->p_bl[$tmp_bl_name] = $bl_name;
          $ipp++;
          $bl_info["vpp"] = 0;
          $bl_info["cpp"] = 0;
          $bl_info["ipp"] = $ipp;
          $bl_info = $this->parse($tmp_bl_name, $bl_info);
          $ipp = $bl_info["ipp"];
        }
      } else {
        $src_list = explode('{', $this->dat["src"][$ipp]);
        reset($src_list);
        if (current($src_list) != '') {
          $this->bl[$bl_name]["-s,$cpp"] = current($src_list);
          $cpp++;
        }
        while ($tmp_src = next($src_list)) {
          $pos = strpos($tmp_src, "}");
          if (($pos !== false) && ($pos > 0)) {
            $len = strlen($tmp_src);
            $varname = substr($tmp_src, 0, $pos);
            if (strstr($varname, ' ')) {
              $this->bl[$bl_name]["-s,$cpp"] = '{'. $tmp_src;
              $cpp++;
            } else {
              $this->bl[$bl_name]["-o,$vpp"] = $varname;
              $vpp++;
              if(($pos + 1) != $len) {
                $this->bl[$bl_name]["-s,$cpp"] = substr($tmp_src, ($pos + 1), ($len - ($pos + 1)));
                $cpp++;
              }
            }
          } else {
            $this->bl[$bl_name]["-s,$cpp"] = '{'. $tmp_src;
            $cpp++;
          }
        }
      }
      $ipp++;
    }
    $bl_info["vpp"] = $vpp;
    $bl_info["cpp"] = $cpp;
    $bl_info["ipp"] = $ipp;
    return $bl_info;
  }

  function assign($name, $value) {
    if(count($ex = explode('.', $name)) == 2) {
      $tmp_block = $ex[0] .'_'. $this->ipp[$ex[0]];	
      $co = count($this->src[$tmp_block]) - 1; if ($co < 0) $co = 0;
      $block = &$this->src[$tmp_block][$co];
      $name = $ex[1];
    } else {
      $block = &$this->bl_idx;
    }
    $block["-o,$name"] = $value;
  }

  function getContentSub($bl_name) {
    $co = count($this->src[$bl_name]);
    for($i=0; $i < $co; $i++) {
      $tmp_name = $this->src[$bl_name][$i][0];
      foreach($this->bl[$tmp_name] as $k=>$val) {
        $tmp = substr($k, 0, 3);
        if ($tmp == "-s,") {
          $this->html_content .= $val;
        } else if ($tmp == "-o,") {
          $this->html_content .= $this->src[$bl_name][$i]["-o,". $val];
        } else if ($tmp == "-a,") {
          if (isset($this->src[$bl_name][$i][$k])) {
            $this->getContentSub($this->src[$bl_name][$i][$k]);
          }
        }
      }
    }
  }

  function newBlock($bl_name) {
    $p_bl = &$this->src[$this->p_bl[$bl_name] .'_'. $this->ipp[$this->p_bl[$bl_name]]];
    $co = count($p_bl) - 1; if ($co < 0) $co = 0;
    $tmp_block = $bl_name .'_'. $this->ipp[$bl_name];
    if (!isset($p_bl[$co]["-a,$bl_name"])) {
      $this->ipp[$bl_name] += 1;
      $tmp_block = $bl_name .'_'. $this->ipp[$bl_name];
      if (!isset($this->src[$tmp_block])) {
        $this->src[$tmp_block] = array();
      }
      $p_bl[$co]["-a,$bl_name"] = $tmp_block;
    }
    $blocksize = count($this->src[$tmp_block]);
    $this->src[$tmp_block][$blocksize] = array($bl_name);
    $this->bl_idx = &$this->src[$tmp_block][$blocksize];
  }

  function gotoBlock($bl_name) {
    if (isset($this->bl[$bl_name])) {
      $tmp_block = $bl_name .'_'. $this->ipp[$bl_name];
      $co = count($this->src[$tmp_block]) - 1; if ($co < 0) $co = 0;
      $this->bl_idx = &$this->src[$tmp_block][$co];
    }
  }

  function getContent() {
    $this->getContentSub("_ROOT_0");
    return $this->html_content;
  }
}
?>
