<?
function parse_tpl($tpl_path) {
  global $include;

  if (file_exists($tpl_path)) {
    $htmlText = file_get_contents($tpl_path);
  } else {
    $htmlText = '';
  }

  $htmlText = str_replace('<!---', '<!-- ', $htmlText);
  $htmlText = str_replace('--->', ' -->', $htmlText);
  
  $inc_pattern = '/<!--\s*INCLUDE\s*(.*?)\s*-->/';
  while(preg_match($inc_pattern, $htmlText, $match)) {
    $inc_tpl_path = "$include/{$match[1]}";
    if (file_exists($inc_tpl_path)) {
      $inc_text = file_get_contents($inc_tpl_path);
      $htmlText = str_replace($match[0], $inc_text, $htmlText);
    } else {
      break;
    }
  }
  
  $parser = new HtmlParser($htmlText);
  
  $parsed_list = array();
  $parsed_list_idx = -1;
  $content_idx = -1;
  $parse_level = 0;
  $tmp_html = '';
  
  while ($parser->parse()) {
    switch($parser->iNodeType) {
  
    case NODE_TYPE_ELEMENT:
  
      $tmp_html .= "<";
      $tmp_html .= $parser->iNodeName;
      foreach($parser->iNodeAttributes as $key=>$val) {
        if (strlen($val)==0) {
          $tmp_html .= " $key";
        } else {
          $tmp_html .= " $key=\"$val\"";
        }
      }
      $tmp_html .= ">";
      break;
  
    case NODE_TYPE_ENDELEMENT:
  
      $tmp_html .= "</";
      $tmp_html .= $parser->iNodeName;
      $tmp_html .= ">";
      break;
  
    case NODE_TYPE_TEXT:
  
      $tmp_html .= $parser->iNodeValue;
      break;
  
    case NODE_TYPE_COMMENT:
  
       //-----------------------------------------------------------------------
  
      if (preg_match('/<!--\s*START\s*BLOCK\s*(.*?)\s*(\n|-->)/', $parser->iNodeValue, $match)) {
  
        $parsed_list_idx++;
        $parsed_list[$parsed_list_idx] = array('TYPE'=>'TEXT', 'TEXT'=>$tmp_html);
        $tmp_html = '';
  
        $parsed_list_idx++;
        $parsed_list[$parsed_list_idx] = array('TYPE'=>'BLOCK', 'NAME'=>$match[1], 'ATTR'=>$parser->iNodeValue, 'CONTENT'=>array());
  
        $parse_level = 1;
        $content_idx = -1;
      }
  
      else //-------------------------------------------------------------------
  
      if (preg_match('/<!--\s*END\s*BLOCK\s*/', $parser->iNodeValue)) {
  
        $content_idx++;
        $parsed_list[$parsed_list_idx]['CONTENT'][$content_idx] = array('TYPE'=>'TEXT', 'TEXT'=>$tmp_html);
        $tmp_html = '';
  
        $parse_level = 0;
      }
  
      else //-------------------------------------------------------------------
  
      if (preg_match('/<!--\s*START\s*COMMON_BLOCK\s*(.*?)\s*(\n|-->)/', $parser->iNodeValue, $match)) {
  
        $parsed_list_idx++;
        $parsed_list[$parsed_list_idx] = array('TYPE'=>'TEXT', 'TEXT'=>$tmp_html);
        $tmp_html = '';
  
        $parsed_list_idx++;
        $parsed_list[$parsed_list_idx] = array('TYPE'=>'COMMON_BLOCK', 'NAME'=>$match[1], 'ATTR'=>$parser->iNodeValue, 'CONTENT'=>array());
  
        $parse_level = 1;
        $content_idx = -1;
      }
  
      else //-------------------------------------------------------------------
  
      if (preg_match('/<!--\s*END\s*COMMON_BLOCK\s*/', $parser->iNodeValue)) {
  
        $content_idx++;
        $parsed_list[$parsed_list_idx]['CONTENT'][$content_idx] = array('TYPE'=>'TEXT', 'TEXT'=>$tmp_html);
        $tmp_html = '';
  
        $parse_level = 0;
      }
  
      else //-------------------------------------------------------------------
  
      if (preg_match('/<!--\s*START\s*LOOP\s*(.*?)\s*(\n|-->)/', $parser->iNodeValue, $match)) {
  
        $content_idx++;
        $parsed_list[$parsed_list_idx]['CONTENT'][$content_idx] = array('TYPE'=>'TEXT', 'TEXT'=>$tmp_html);
        $tmp_html = '';
  
        $content_idx++;
        $parsed_list[$parsed_list_idx]['CONTENT'][$content_idx] = array('TYPE'=>'LOOP', 'NAME'=>$match[1], 'ATTR'=>$parser->iNodeValue, 'LOOP_CONTENT'=>array());
  
        $parse_level = 2;
      }
  
      else //-------------------------------------------------------------------
  
      if (preg_match('/<!--\s*END\s*LOOP\s*/', $parser->iNodeValue)) {
  
        $parsed_list[$parsed_list_idx]['CONTENT'][$content_idx]['LOOP_CONTENT'][] = array('TYPE'=>'TEXT', 'TEXT'=>$tmp_html);
        $tmp_html = '';
  
        $parse_level = 1;
      }
  
      else //-------------------------------------------------------------------
  
      if (preg_match('/<!--\s*EX_EDIT\s*(.*?)\s*(\n|-->)/', $parser->iNodeValue, $match)) {
  
        $name_list = preg_split('/\s+/', $match[1]);
        $tmp_attr_list = get_attr($parser->iNodeValue);

        if ($parse_level==1) {
          $content_idx++;
          $parsed_list[$parsed_list_idx]['CONTENT'][$content_idx] = array('TYPE'=>'TEXT', 'TEXT'=>$tmp_html);
          $tmp_html = '';
  
          $content_idx++;
          $parsed_list[$parsed_list_idx]['CONTENT'][$content_idx] = array('TYPE'=>'EX_EDIT', 'NAME'=>$name_list, 'EX_TYPE'=>$tmp_attr_list['@TYPE'], 'ATTR'=>$parser->iNodeValue);
        }
  
        //----------------------------------------------------------------------
  
        if ($parse_level==2) {
          $parsed_list[$parsed_list_idx]['CONTENT'][$content_idx]['LOOP_CONTENT'][] = array('TYPE'=>'TEXT', 'TEXT'=>$tmp_html);
          $tmp_html = '';
  
          $parsed_list[$parsed_list_idx]['CONTENT'][$content_idx]['LOOP_CONTENT'][] = array('TYPE'=>'EX_EDIT', 'NAME'=>$name_list, 'EX_TYPE'=>$tmp_attr_list['@TYPE'], 'ATTR'=>$parser->iNodeValue);
        }
      }
  
      else //-------------------------------------------------------------------
  
      if (preg_match('/<!--\s*EDIT\s*(.*?)\s*(\n|-->)/', $parser->iNodeValue, $match)) {
  
        if ($parse_level==1) {
  
          $content_idx++;
          $parsed_list[$parsed_list_idx]['CONTENT'][$content_idx] = array('TYPE'=>'TEXT', 'TEXT'=>$tmp_html);
          $tmp_html = '';
  
          $content_idx++;
          $parsed_list[$parsed_list_idx]['CONTENT'][$content_idx] = array('TYPE'=>'EDIT', 'NAME'=>$match[1], 'ATTR'=>$parser->iNodeValue);
        }
  
        //----------------------------------------------------------------------
  
        if ($parse_level==2) {
  
          $parsed_list[$parsed_list_idx]['CONTENT'][$content_idx]['LOOP_CONTENT'][
  ] = array('TYPE'=>'TEXT', 'TEXT'=>$tmp_html);
          $tmp_html = '';
  
          $parsed_list[$parsed_list_idx]['CONTENT'][$content_idx]['LOOP_CONTENT'][] = array('TYPE'=>'EDIT', 'NAME'=>$match[1], 'ATTR'=>$parser->iNodeValue);
        }
      }
  
      else //-------------------------------------------------------------------
  
      if (preg_match('/<!--\s*TEMPLATE\s*/', $parser->iNodeValue, $match)) {
  
        $parsed_list_idx++;
        $parsed_list[$parsed_list_idx] = array('TYPE'=>'TEXT', 'TEXT'=>$tmp_html);
        $tmp_html = '';

        $parsed_list_idx++;
        $parsed_list[$parsed_list_idx] = array('TYPE'=>'TEMPLATE', 'ATTR'=>$parser->iNodeValue);
      }

      else //-------------------------------------------------------------------
      {
        if ($parse_level==1) {
          $content_idx++;
          $parsed_list[$parsed_list_idx]['CONTENT'][$content_idx] = array('TYPE'=>'TEXT', 'TEXT'=>$tmp_html);
          $tmp_html = '';
  
          $content_idx++;
          $parsed_list[$parsed_list_idx]['CONTENT'][$content_idx] = array('TYPE'=>'TEXT', 'TEXT'=>$parser->iNodeValue);
        }
  
        //----------------------------------------------------------------------
  
        if ($parse_level==2) {
          $parsed_list[$parsed_list_idx]['CONTENT'][$content_idx]['LOOP_CONTENT'][] = array('TYPE'=>'TEXT', 'TEXT'=>$tmp_html);
          $tmp_html = '';
  
          $parsed_list[$parsed_list_idx]['CONTENT'][$content_idx]['LOOP_CONTENT'][] = array('TYPE'=>'TEXT', 'TEXT'=>$parser->iNodeValue);
        }
      }
  
      break;
    }
  }
  $parsed_list_idx++;
  $parsed_list[$parsed_list_idx] = array('TYPE'=>'TEXT', 'TEXT'=>$tmp_html);

  return $parsed_list;
}
?>
