/*
 * Copyright 2000-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.pal.blog.bean;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;

import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;

import jp.sf.pal.blog.BlogConstants;
import jp.sf.pal.blog.model.BlogMessage;
import jp.sf.pal.blog.util.BlogMessaging;

import com.marevol.utils.hibernate.HibernateUtil;
import com.marevol.utils.portlet.faces.PortletResourceBundleUtil;

public class BlogEditPageBean
{
    /**
     * Logger for this class
     */
    private static final Log log = LogFactory.getLog(BlogEditPageBean.class);

    private Long id;

    private String title;

    private String message;

    private Date createdTime;

    private Date updatedTime;

    private BlogEditPortletBean editPortlet;

    public BlogEditPageBean()
    {
        Long id = null;
        try
        {
            id = (Long) BlogMessaging.receiveForEdit(BlogConstants.BLOG_MESSAGE_ID);
        }
        catch (ClassCastException e)
        {
            log.warn(e);
        }

        if (id != null)
        {
            if (log.isDebugEnabled())
            {
                log.debug("BlogEditPageBean() -  : id=" + id.toString());
            }

            setId(id);
            //            HibernateUtil.beginTransaction();

            BlogMessage blogMsg = (BlogMessage) HibernateUtil.get(BlogMessage.class, id);
            if (blogMsg != null)
            {
                setTitle(blogMsg.getTitle());
                setMessage(blogMsg.getMessage());
                setCreatedTime(blogMsg.getCreatedtime());
                setUpdatedTime(blogMsg.getUpdatedtime());
            }
            else
            {
                // i18n
                Object[] params = new Object[] { id.toString() };
                getEditPortlet().addMsgAlert(PortletResourceBundleUtil.getString("blogedit.IDIsNotFound", params));
            }
        }
        else
        {
            if (log.isDebugEnabled())
            {
                log.debug("BlogEditPageBean() - id = null");
            }
        }
    }

    public String save()
    {
        if (log.isDebugEnabled())
        {
            log.debug("save() - start");
        }

        ExternalContext externalContext = FacesContext.getCurrentInstance().getExternalContext();

        if (externalContext.getRemoteUser() == null)
        {
            // i18n
            getEditPortlet().addMsgError(PortletResourceBundleUtil.getString("blogedit.UnknownUser"));

            if (log.isDebugEnabled())
            {
                log.debug("save() - end");
            }
            return null;
        }

        if (log.isDebugEnabled())
        {
            log.debug("save() - getId()=" + getId());
        }

        if (getId() == null)
        {
            // create a new blog message
            try
            {
                HibernateUtil.beginTransaction();

                BlogMessage blogMsg = new BlogMessage();
                blogMsg.setOwner(externalContext.getRemoteUser());
                Date now = Calendar.getInstance().getTime();
                blogMsg.setCreatedtime(now);
                blogMsg.setUpdatedtime(now);
                blogMsg.setFormattype(BlogConstants.TEXT_FORMAT_TYPE);
                blogMsg.setTitle(getTitle());
                blogMsg.setMessage(getMessage());

                HibernateUtil.save(blogMsg);

                HibernateUtil.commit();

                // i18n
                getEditPortlet().setMsgSuccess(PortletResourceBundleUtil.getString("blogedit.SaveMsg"));
            }
            catch (RuntimeException e)
            {
                log.error(e);
                HibernateUtil.rollback();
                // i18n
                getEditPortlet().setMsgError(PortletResourceBundleUtil.getString("blogedit.DatabaseAccessError"));
            }

        }
        else
        {
            // update the blog message
            try
            {
                HibernateUtil.beginTransaction();

                BlogMessage blogMsg = (BlogMessage) HibernateUtil.get(BlogMessage.class, id);
                blogMsg.setOwner(externalContext.getRemoteUser());
                Date now = Calendar.getInstance().getTime();
                // blogMsg.setCreatedtime(now);
                blogMsg.setUpdatedtime(now);
                blogMsg.setFormattype(BlogConstants.TEXT_FORMAT_TYPE);
                blogMsg.setTitle(getTitle());
                blogMsg.setMessage(getMessage());

                HibernateUtil.save(blogMsg);

                HibernateUtil.commit();

                // i18n
                getEditPortlet().setMsgSuccess(PortletResourceBundleUtil.getString("blogedit.UpdatedMsg"));
            }
            catch (HibernateException e)
            {
                log.error(e);
                HibernateUtil.rollback();
                // i18n
                getEditPortlet().setMsgError(PortletResourceBundleUtil.getString("blogedit.DatabaseAccessError"));
            }

        }

        if (log.isDebugEnabled())
        {
            log.debug("save() - end");
        }
        return null;
    }

    public String reset()
    {
        if (getId() != null)
        {
            BlogMessaging.cancelForEdit(BlogConstants.BLOG_MESSAGE_ID);
            // i18n
            getEditPortlet().setMsgInfo(PortletResourceBundleUtil.getString("blogedit.ReadyToCreateANewData"));
        }
        return null;
    }

    public String delete()
    {
        if (getId() != null)
        {
            try
            {
                HibernateUtil.beginTransaction();

                BlogMessage blogMsg = (BlogMessage) HibernateUtil.get(BlogMessage.class, id);

                HibernateUtil.delete(blogMsg);

                HibernateUtil.commit();

                setId(null);

                // i18n
                getEditPortlet().setMsgSuccess(PortletResourceBundleUtil.getString("blogedit.DeletedMsg"));
            }
            catch (HibernateException e)
            {
                log.error(e);
                HibernateUtil.rollback();
                // i18n
                getEditPortlet().setMsgError(PortletResourceBundleUtil.getString("blogedit.DatabaseAccessError"));
            }

        }
        else
        {
            // i18n
            getEditPortlet().setMsgError(PortletResourceBundleUtil.getString("blogedit.TheSpecifiedDataIDIsNull"));
        }
        return null;
    }

    // Setter and Getter

    /**
     * @return Returns the message.
     */
    public String getMessage()
    {
        if (log.isDebugEnabled())
        {
            log.debug("getMessage() - start");
        }

        if (log.isDebugEnabled())
        {
            log.debug("getMessage() - end");
        }
        return message;
    }

    /**
     * @param message The message to set.
     */
    public void setMessage(String message)
    {
        if (log.isDebugEnabled())
        {
            log.debug("setMessage(String) - start");
        }

        this.message = message;

        if (log.isDebugEnabled())
        {
            log.debug("setMessage(String) - end");
        }
    }

    /**
     * @return Returns the title.
     */
    public String getTitle()
    {
        if (log.isDebugEnabled())
        {
            log.debug("getTitle() - start");
        }

        if (log.isDebugEnabled())
        {
            log.debug("getTitle() - end");
        }
        return title;
    }

    /**
     * @param title The title to set.
     */
    public void setTitle(String title)
    {
        if (log.isDebugEnabled())
        {
            log.debug("setTitle(String) - start");
        }

        this.title = title;

        if (log.isDebugEnabled())
        {
            log.debug("setTitle(String) - end");
        }
    }

    /**
     * @return Returns the editPortlet.
     */
    public BlogEditPortletBean getEditPortlet()
    {
        if (log.isDebugEnabled())
        {
            log.debug("getEditPortlet() - start");
        }

        if (log.isDebugEnabled())
        {
            log.debug("getEditPortlet() - end");
        }
        return editPortlet;
    }

    /**
     * @param editPortlet The editPortlet to set.
     */
    public void setEditPortlet(BlogEditPortletBean editPortlet)
    {
        if (log.isDebugEnabled())
        {
            log.debug("setEditPortlet(BlogEditPortletBean) - start");
        }

        this.editPortlet = editPortlet;

        if (log.isDebugEnabled())
        {
            log.debug("setEditPortlet(BlogEditPortletBean) - end");
        }
    }

    /**
     * @return Returns the id.
     */
    public Long getId()
    {
        if (log.isDebugEnabled())
        {
            log.debug("getId() - start");
        }

        if (log.isDebugEnabled())
        {
            log.debug("getId() - end");
        }
        return id;
    }

    /**
     * @param id The id to set.
     */
    public void setId(Long id)
    {
        if (log.isDebugEnabled())
        {
            log.debug("setId(Long) - start");
        }

        this.id = id;

        if (log.isDebugEnabled())
        {
            log.debug("setId(Long) - end");
        }
    }

    /**
     * @return Returns the createdTime.
     */
    public Date getCreatedTime()
    {
        return createdTime;
    }

    public String getFormattedCreatedTime()
    {
        if (getCreatedTime() == null)
        {
            return BlogConstants.NONEXISTENT_VALUE;
        }

        UIViewRoot viewRoot = FacesContext.getCurrentInstance().getViewRoot();
        Locale locale = null;
        if (viewRoot != null)
        {
            locale = viewRoot.getLocale();
        }
        else
        {
            locale = Locale.ENGLISH;
        }

        DateFormat df = DateFormat.getDateTimeInstance(DateFormat.MEDIUM, DateFormat.MEDIUM, locale);
        return df.format(getCreatedTime());
    }

    /**
     * @param createdTime The createdTime to set.
     */
    public void setCreatedTime(Date createdDate)
    {
        this.createdTime = createdDate;
    }

    /**
     * @return Returns the updatedTime.
     */
    public Date getUpdatedTime()
    {
        return updatedTime;
    }

    public String getFormattedUpdatedTime()
    {
        if (getUpdatedTime() == null)
        {
            return BlogConstants.NONEXISTENT_VALUE;
        }

        UIViewRoot viewRoot = FacesContext.getCurrentInstance().getViewRoot();
        Locale locale = null;
        if (viewRoot != null)
        {
            locale = viewRoot.getLocale();
        }
        else
        {
            locale = Locale.ENGLISH;
        }

        DateFormat df = DateFormat.getDateTimeInstance(DateFormat.MEDIUM, DateFormat.MEDIUM, locale);
        return df.format(getUpdatedTime());
    }

    /**
     * @param updatedTime The updatedTime to set.
     */
    public void setUpdatedTime(Date updatedDate)
    {
        this.updatedTime = updatedDate;
    }

}
