/*
 * Copyright 2000-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.pal.blog.bean;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.io.NotSerializableException;
import java.util.Map;

import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.model.DataModel;

import com.marevol.utils.hibernate.faces.model.HibernateDataModel;

import jp.sf.pal.blog.BlogConstants;
import jp.sf.pal.blog.model.BlogMessage;
import jp.sf.pal.blog.util.BlogMessaging;

public class BlogTitleViewPageBean
{
    /**
     * Logger for this class
     */
    private static final Log log = LogFactory.getLog(BlogTitleViewPageBean.class);

    private BlogTitleViewPortletBean titleViewPortlet;

    public BlogTitleViewPageBean()
    {
    }

    public String select()
    {
        if (log.isDebugEnabled())
        {
            log.debug("select() - start");
        }

        ExternalContext exContext = FacesContext.getCurrentInstance().getExternalContext();
        Map map = exContext.getRequestMap();
        Map blogMap = (Map) map.get("blogMsg");
        BlogMessage blogMsg = (BlogMessage) blogMap.get("0");
        if (blogMsg != null)
        {
            try
            {
                BlogMessaging.publishToAll(BlogConstants.BLOG_MESSAGE_ID, blogMsg.getId());
            }
            catch (NotSerializableException e)
            {
                log.error(e);
            }
            catch (ClassCastException e)
            {
                log.error(e);
            }
        }
        else
        {
            log.error("Selected BlogMessage is null.");
        }

        if (log.isDebugEnabled())
        {
            log.debug("select() - end");
        }
        return null;
    }

    private String getSortColumn()
    {
        String column = getTitleViewPortlet().getSortColumn();
        if (log.isDebugEnabled())
        {
            log.debug("getSortColumn() -  : column=" + column);
        }
        if (column.equalsIgnoreCase(BlogMessage.CREATEDTIME))
        {
            return "msg." + BlogMessage.CREATEDTIME;
        }
        else if (column.equalsIgnoreCase(BlogMessage.UPDATEDTIME))
        {
            return "msg." + BlogMessage.UPDATEDTIME;
        }

        if (log.isDebugEnabled())
        {
            log.debug("getSortColumn() - : column does not match..");
        }
        return "msg." + BlogMessage.CREATEDTIME;
    }

    // Getter and Setter

    /**
     * @return Returns the titleViewPortlet.
     */
    public BlogTitleViewPortletBean getTitleViewPortlet()
    {
        if (log.isDebugEnabled())
        {
            log.debug("getTitleViewPortlet() - start");
        }

        if (log.isDebugEnabled())
        {
            log.debug("getTitleViewPortlet() - end");
        }
        return titleViewPortlet;
    }

    /**
     * @param titleViewPortlet The titleViewPortlet to set.
     */
    public void setTitleViewPortlet(BlogTitleViewPortletBean titleViewPortlet)
    {
        if (log.isDebugEnabled())
        {
            log.debug("setTitleViewPortlet(BlogTitleViewPortletBean) - start");
        }

        this.titleViewPortlet = titleViewPortlet;

        if (log.isDebugEnabled())
        {
            log.debug("setTitleViewPortlet(BlogTitleViewPortletBean) - end");
        }
    }

    /**
     * @return Returns the blogMessages.
     */
    public DataModel getBlogMessages()
    {
        if (log.isDebugEnabled())
        {
            log.debug("getBlogMessages()");
        }
        Object[] params = { getTitleViewPortlet().getOwner() };

        return new HibernateDataModel("select msg from BlogMessage msg where msg.owner = ? order by " + getSortColumn()
                + " desc", params);
    }

}
