/*
 * Copyright 2000-2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.pal.blog.portlet;

import java.io.IOException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletException;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.UnavailableException;

import com.marevol.utils.hibernate.HibernateUtil;

import jp.sf.pal.myfaces.portlet.MyFacesGenericPortlet;

public class BlogGenericPortlet extends MyFacesGenericPortlet
{
    /**
     * Logger for this class
     */
    private static final Log log = LogFactory.getLog(BlogGenericPortlet.class);

    /* (non-Javadoc)
     * @see jp.sf.pal.myfaces.portlet.MyFacesGenericPortlet#init()
     */
    public void init() throws PortletException, UnavailableException
    {
        if (log.isDebugEnabled())
        {
            log.debug("init() - start");
        }

        super.init();

        HibernateUtil.init(getPortletConfig());

        if (log.isDebugEnabled())
        {
            log.debug("init() - end");
        }

    }

    /* (non-Javadoc)
     * @see jp.sf.pal.myfaces.portlet.MyFacesGenericPortlet#processAction(javax.portlet.ActionRequest, javax.portlet.ActionResponse)
     */
    public void processAction(ActionRequest arg0, ActionResponse arg1) throws PortletException, IOException
    {
        HibernateUtil.openSession();
        super.processAction(arg0, arg1);
        HibernateUtil.closeSession();
    }

    /* (non-Javadoc)
     * @see javax.portlet.GenericPortlet#render(javax.portlet.RenderRequest, javax.portlet.RenderResponse)
     */
    public void render(RenderRequest arg0, RenderResponse arg1) throws PortletException, IOException
    {
        HibernateUtil.openSession();
        super.render(arg0, arg1);
        HibernateUtil.closeSession();
    }
}
