/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.X509EncodedKeySpec;
import java.util.Properties;
import java.util.Vector;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.SecretKeySpec;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Header;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.protocols.PingRsp;
import org.jgroups.stack.Protocol;

public class ENCRYPT1_4
extends Protocol {
    Address local_addr = null;
    Address keyServerAddr = null;
    boolean keyServer = false;
    String asymAlgorithm = "RSA";
    String symAlgorithm = "DES/ECB/PKCS5Padding";
    int asymInit = 512;
    int symInit = 56;
    KeyPair Kpair;
    SecretKey desKey = null;
    PublicKey pubKey = null;
    PublicKey serverPubKey = null;
    Cipher cipher;
    Cipher rsa;
    Vector members = new Vector();
    Vector notReady = new Vector();

    public String getName() {
        return "ENCRYPT1_4";
    }

    private String getAlgorithm(String s) {
        int index = s.indexOf("/");
        if (index == -1) {
            return s;
        }
        return s.substring(0, index);
    }

    public boolean setProperties(Properties props) {
        super.setProperties(props);
        String str = props.getProperty("asymInit");
        if (str != null) {
            this.asymInit = Integer.parseInt(str);
            props.remove("asymInit");
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)("Asym algo bits used is " + this.asymInit));
            }
        }
        if ((str = props.getProperty("symInit")) != null) {
            this.symInit = Integer.parseInt(str);
            props.remove("symInit");
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)("Sym algo bits used is " + this.symInit));
            }
        }
        if ((str = props.getProperty("asymAlgorithm")) != null) {
            this.asymAlgorithm = str;
            props.remove("asymAlgorithm");
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)("Asym algo used is " + this.asymAlgorithm));
            }
        }
        if ((str = props.getProperty("symAlgorithm")) != null) {
            this.symAlgorithm = str;
            props.remove("symAlgorithm");
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)("Sym algo used is " + this.symAlgorithm));
            }
        }
        if (props.size() > 0) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("these properties are not recognized:" + props));
            }
            return false;
        }
        return true;
    }

    public void init() throws Exception {
        KeyPairGenerator KpairGen = KeyPairGenerator.getInstance(this.getAlgorithm(this.asymAlgorithm));
        KpairGen.initialize(this.asymInit, new SecureRandom());
        this.Kpair = KpairGen.generateKeyPair();
        KeyGenerator keyGen = KeyGenerator.getInstance(this.getAlgorithm(this.symAlgorithm));
        keyGen.init(this.symInit);
        this.desKey = keyGen.generateKey();
        this.rsa = Cipher.getInstance(this.asymAlgorithm);
        this.cipher = Cipher.getInstance(this.symAlgorithm);
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)" Both asym and sym algo initialized with the single shared key");
        }
    }

    public void reset() {
    }

    public void up(Event evt) {
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)("Event going up is " + evt));
        }
        switch (evt.getType()) {
            case 8: {
                if (this.log.isInfoEnabled()) {
                    this.log.info((Object)"Set address call");
                }
                this.local_addr = (Address)evt.getArg();
                break;
            }
            case 13: {
                Vector member = (Vector)evt.getArg();
                if (this.log.isInfoEnabled()) {
                    this.log.info((Object)("FIND_INIT members call, left members are " + member.size()));
                }
                if (!this.keyServer) {
                    this.keyServer = member.size() <= 0;
                }
                this.keyServerAddr = member != null && member.size() > 0 ? ((PingRsp)member.firstElement()).coord_addr : this.local_addr;
                if (!this.keyServer) {
                    this.desKey = null;
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)"This is not keyserver, deskey set to null");
                    }
                    Message newMsg = new Message(this.keyServerAddr, this.local_addr, this.Kpair.getPublic().getEncoded());
                    newMsg.putHeader("encrypt", new EncryptHeader(1));
                    this.passDown(new Event(1, newMsg));
                }
                if (this.log.isInfoEnabled()) {
                    this.log.info((Object)("Done parsing for encrypt headers, sending upwards" + evt));
                }
                this.passUp(evt);
                return;
            }
            case 1: {
                Message msg = (Message)evt.getArg();
                if (this.log.isInfoEnabled()) {
                    this.log.info((Object)("This is a message from peer, not control header" + msg));
                }
                if (msg == null) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)"Null message");
                    }
                    this.passUp(evt);
                    return;
                }
                Header obj = msg.removeHeader("encrypt");
                if (this.log.isInfoEnabled()) {
                    this.log.info((Object)"Stripping the required protocol header");
                }
                if (obj == null || !(obj instanceof EncryptHeader)) {
                    if (this.log.isInfoEnabled()) {
                        this.log.info((Object)"Dropping package as ENCRYPT1_4 protocol is not been recognized, msg will not be passed up");
                    }
                    return;
                }
                EncryptHeader hdr = (EncryptHeader)obj;
                if (this.log.isInfoEnabled()) {
                    this.log.info((Object)("Header received " + hdr + ':' + hdr.type));
                }
                switch (hdr.type) {
                    case 1: {
                        try {
                            if (this.log.isDebugEnabled()) {
                                this.log.debug((Object)"Request for key");
                            }
                            this.notReady.addElement(msg.getSrc());
                            PublicKey pubKey = this.generatePubKey(msg.getBuffer());
                            if (this.log.isDebugEnabled()) {
                                this.log.debug((Object)"Generated requestors public key");
                            }
                            Message newMsg = new Message(msg.getSrc(), this.local_addr, this.Kpair.getPublic().getEncoded());
                            newMsg.putHeader("encrypt", new EncryptHeader(2));
                            if (this.log.isDebugEnabled()) {
                                this.log.debug((Object)"Encoded servers public key using clients public key, only client can debug it using its private key and sending it back");
                            }
                            this.passDown(new Event(1, newMsg));
                            this.rsa.init(1, pubKey);
                            byte[] encryptedKey = this.rsa.doFinal(this.desKey.getEncoded());
                            if (this.log.isDebugEnabled()) {
                                this.log.debug((Object)" Generated encoded key which only client can decode");
                            }
                            newMsg = new Message(msg.getSrc(), this.local_addr, encryptedKey);
                            newMsg.putHeader("encrypt", new EncryptHeader(3));
                            if (this.log.isDebugEnabled()) {
                                this.log.debug((Object)" Sending encoded key to client");
                            }
                            this.passDown(new Event(1, newMsg));
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            System.out.println(e + "0");
                        }
                        return;
                    }
                    case 4: {
                        this.notReady.removeElement(msg.getSrc());
                        if (this.log.isDebugEnabled()) {
                            this.log.debug((Object)("Removed client " + msg.getSrc() + "from notready list"));
                        }
                        return;
                    }
                    case 2: {
                        this.serverPubKey = this.generatePubKey(msg.getBuffer());
                        if (this.log.isDebugEnabled()) {
                            this.log.debug((Object)" Obtained the servers public key");
                        }
                        return;
                    }
                    case 3: {
                        try {
                            this.rsa.init(2, this.Kpair.getPrivate());
                            byte[] encodedKey = this.rsa.doFinal(msg.getBuffer());
                            if (this.log.isDebugEnabled()) {
                                this.log.debug((Object)"generating encoded key obtained from server-admin");
                            }
                            this.desKey = this.decodedKey(encodedKey);
                            if (this.desKey == null) {
                                this.log.error((Object)"ohh oh !! DES key is null");
                            }
                            Message newMsg = new Message(msg.getSrc(), this.local_addr, null);
                            newMsg.putHeader("encrypt", new EncryptHeader(4));
                            this.passDown(new Event(1, newMsg));
                            if (this.log.isDebugEnabled()) {
                                this.log.debug((Object)"Got the deskey, sending down sec_Ready header");
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            System.out.println(e + "5");
                        }
                        return;
                    }
                }
                if (hdr.type != 0) {
                    this.log.error((Object)"Error , header is not 0");
                }
                if (this.desKey == null) {
                    return;
                }
                if (this.log.isInfoEnabled()) {
                    this.log.info((Object)" Starting to decypher messages");
                }
                if (msg.getBuffer() == null) break;
                try {
                    this.cipher.init(2, this.desKey);
                    msg.setBuffer(this.cipher.doFinal(msg.getBuffer()));
                    break;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)"Passing up event");
        }
        this.passUp(evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void down(Event evt) {
        boolean leave = false;
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)("down:evt is " + evt + ':' + evt.getType()));
        }
        switch (evt.getType()) {
            case 6: {
                if (this.log.isInfoEnabled()) {
                    this.log.info((Object)"View change call, new member coming in");
                }
                Vector new_members = ((View)evt.getArg()).getMembers();
                if (this.members.size() > new_members.size()) {
                    leave = true;
                }
                Vector vector = this.members;
                synchronized (vector) {
                    this.members.removeAllElements();
                    if (new_members != null && new_members.size() > 0) {
                        for (int i = 0; i < new_members.size(); ++i) {
                            this.members.addElement(new_members.elementAt(i));
                        }
                    }
                }
                if (!leave) break;
                Object obj = this.members.firstElement();
                if (obj.equals(this.local_addr)) {
                    this.keyServer = true;
                    this.keyServerAddr = this.local_addr;
                    this.desKey = null;
                    if (this.log.isInfoEnabled()) {
                        this.log.info((Object)" leave caused deskey to be null ");
                    }
                    try {
                        KeyGenerator keyGen = KeyGenerator.getInstance(this.getAlgorithm(this.symAlgorithm));
                        keyGen.init(this.symInit);
                        this.desKey = keyGen.generateKey();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    break;
                }
                this.keyServer = false;
                this.keyServerAddr = (Address)obj;
                this.desKey = null;
                Message newMsg = new Message(this.keyServerAddr, this.local_addr, this.Kpair.getPublic().getEncoded());
                newMsg.putHeader("encrypt", new EncryptHeader(1));
                this.passDown(new Event(1, newMsg));
                if (!this.log.isDebugEnabled()) break;
                this.log.debug((Object)"Requesting new key to be part of group");
                break;
            }
            case 1: {
                Message msg = (Message)evt.getArg();
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Its a message call " + msg));
                }
                if (!this.notReady.isEmpty()) {
                    System.out.println("not Ready list  :" + this.notReady.toString());
                    if (msg.getDest() == null) {
                        for (int i = 0; i < this.notReady.size(); ++i) {
                            Message newMsg = new Message((Address)this.notReady.elementAt(i), this.local_addr, msg.getBuffer());
                            this.passDown(new Event(1, newMsg));
                        }
                        break;
                    }
                    for (int i = 0; i < this.notReady.size(); ++i) {
                        if (msg.getDest() != this.notReady.elementAt(i)) continue;
                        this.passDown(evt);
                        return;
                    }
                }
                if (this.desKey == null) break;
                if (this.log.isInfoEnabled()) {
                    this.log.info((Object)"DESkey is not null, I know it ");
                }
                try {
                    if (msg.getBuffer() != null) {
                        this.cipher.init(1, this.desKey);
                        msg.setBuffer(this.cipher.doFinal(msg.getBuffer()));
                        msg.putHeader("encrypt", new EncryptHeader(0));
                        if (!this.log.isInfoEnabled()) break;
                        this.log.info((Object)" have DES key , package sent");
                        break;
                    }
                    msg.setBuffer(null);
                    msg.putHeader("encrypt", new EncryptHeader(0));
                    if (!this.log.isInfoEnabled()) break;
                    this.log.info((Object)" buffer null, added header");
                    break;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)("Pass Down: " + evt.toString()));
        }
        this.passDown(evt);
    }

    private SecretKey decodedKey(byte[] encodedKey) {
        SecretKey key = null;
        try {
            SecretKeyFactory KeyFac = SecretKeyFactory.getInstance(this.getAlgorithm(this.symAlgorithm));
            SecretKeySpec desKeySpec = new SecretKeySpec(encodedKey, this.getAlgorithm(this.symAlgorithm));
            key = KeyFac.generateSecret(desKeySpec);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return key;
    }

    private PublicKey generatePubKey(byte[] encodedKey) {
        PublicKey pubKey = null;
        try {
            KeyFactory KeyFac = KeyFactory.getInstance(this.getAlgorithm(this.asymAlgorithm));
            X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(encodedKey);
            pubKey = KeyFac.generatePublic(x509KeySpec);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return pubKey;
    }

    public static class EncryptHeader
    extends Header {
        int type;
        static final int ENCRYPT = 0;
        static final int KEY_REQUEST = 1;
        static final int SERVER_PUBKEY = 2;
        static final int SECRETKEY = 3;
        static final int SECRETKEY_READY = 4;
        static final String KEY = "encrypt";

        public EncryptHeader() {
        }

        public EncryptHeader(int type) {
            this.type = type;
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.type);
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.type = in.readInt();
        }

        public String toString() {
            return "[ENCTYPT: <variables> ]";
        }
    }
}

