/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.pbcast;

import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.Vector;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Header;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.protocols.pbcast.Digest;
import org.jgroups.protocols.pbcast.NakAckHeader;
import org.jgroups.stack.NakReceiverWindow;
import org.jgroups.stack.Protocol;
import org.jgroups.stack.Retransmitter;
import org.jgroups.util.Range;
import org.jgroups.util.TimeScheduler;
import org.jgroups.util.Util;

public class NAKACK
extends Protocol
implements Retransmitter.RetransmitCommand {
    long[] retransmit_timeout = new long[]{600L, 1200L, 2400L, 4800L};
    boolean is_server = false;
    Address local_addr = null;
    Vector members = new Vector(11);
    long seqno = 0L;
    long max_xmit_size = 8192L;
    int gc_lag = 20;
    boolean use_mcast_xmit = false;
    boolean discard_delivered_msgs = false;
    HashMap received_msgs = new HashMap(11);
    TreeMap sent_msgs = new TreeMap();
    boolean leaving = false;
    TimeScheduler timer = null;
    final String name = "NAKACK";

    public String getName() {
        return "NAKACK";
    }

    public Vector providedUpServices() {
        Vector<Integer> retval = new Vector<Integer>(5);
        retval.addElement(new Integer(39));
        retval.addElement(new Integer(57));
        retval.addElement(new Integer(42));
        retval.addElement(new Integer(41));
        retval.addElement(new Integer(53));
        return retval;
    }

    public Vector providedDownServices() {
        Vector<Integer> retval = new Vector<Integer>(2);
        retval.addElement(new Integer(39));
        retval.addElement(new Integer(57));
        return retval;
    }

    public void start() throws Exception {
        TimeScheduler timeScheduler = this.timer = this.stack != null ? this.stack.timer : null;
        if (this.timer == null) {
            throw new Exception("NAKACK.up(): timer is null");
        }
    }

    public void stop() {
        if (this.timer != null) {
            try {
                this.timer.stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.removeAll();
    }

    public void down(Event evt) {
        switch (evt.getType()) {
            case 1: {
                Message msg = (Message)evt.getArg();
                if (msg.getDest() != null && !msg.getDest().isMulticastAddress()) break;
                this.send(msg);
                msg = null;
                evt = null;
                return;
            }
            case 30: {
                this.stable((Digest)evt.getArg());
                return;
            }
            case 39: {
                Digest digest = this.getDigest();
                this.passUp(new Event(40, digest != null ? digest.copy() : null));
                return;
            }
            case 57: {
                Digest digest = this.getDigestHighestDeliveredMsgs();
                this.passUp(new Event(58, digest != null ? digest.copy() : null));
                return;
            }
            case 42: {
                Digest digest = this.getDigest();
                this.passUp(new Event(43, digest != null ? digest.copy() : null));
                return;
            }
            case 41: {
                this.setDigest((Digest)evt.getArg());
                return;
            }
            case 53: {
                this.mergeDigest((Digest)evt.getArg());
                return;
            }
            case 56: {
                this.passDown(evt);
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("received CONFIG event: " + evt.getArg()));
                }
                this.handleConfigEvent((HashMap)evt.getArg());
                return;
            }
            case 15: {
                Vector mbrs = ((View)evt.getArg()).getMembers();
                this.members.removeAllElements();
                this.members.addAll(mbrs);
                this.adjustReceivers();
                break;
            }
            case 6: {
                Vector mbrs = ((View)evt.getArg()).getMembers();
                this.members.removeAllElements();
                this.members.addAll(mbrs);
                this.adjustReceivers();
                this.is_server = true;
                break;
            }
            case 16: {
                this.is_server = true;
                break;
            }
            case 4: {
                this.leaving = true;
                this.removeAll();
                this.seqno = 0L;
            }
        }
        this.passDown(evt);
    }

    public void up(Event evt) {
        switch (evt.getType()) {
            case 30: {
                this.stable((Digest)evt.getArg());
                return;
            }
            case 39: {
                Digest digest = this.getDigestHighestDeliveredMsgs();
                this.passDown(new Event(40, digest));
                return;
            }
            case 57: {
                Digest digest = this.getDigestHighestDeliveredMsgs();
                this.passDown(new Event(58, digest));
                return;
            }
            case 8: {
                this.local_addr = (Address)evt.getArg();
                break;
            }
            case 56: {
                this.passUp(evt);
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("received CONFIG event: " + evt.getArg()));
                }
                this.handleConfigEvent((HashMap)evt.getArg());
                return;
            }
            case 1: {
                Message msg = (Message)evt.getArg();
                Header obj = msg.getHeader("NAKACK");
                if (obj == null || !(obj instanceof NakAckHeader)) break;
                if (!this.is_server) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)"message was discarded (not yet server)");
                    }
                    return;
                }
                NakAckHeader hdr = (NakAckHeader)obj;
                switch (hdr.type) {
                    case 1: {
                        this.handleMessage(msg, hdr);
                        return;
                    }
                    case 2: {
                        if (hdr.range == null) {
                            if (this.log.isErrorEnabled()) {
                                this.log.error((Object)("XMIT_REQ: range of xmit msg is null; discarding request from " + msg.getSrc()));
                            }
                            return;
                        }
                        this.handleXmitReq(msg.getSrc(), hdr.range.low, hdr.range.high);
                        return;
                    }
                    case 3: {
                        if (this.log.isTraceEnabled()) {
                            this.log.trace((Object)("received missing messages " + hdr.range));
                        }
                        this.handleXmitRsp(msg);
                        return;
                    }
                }
                if (this.log.isErrorEnabled()) {
                    this.log.error((Object)("NakAck header type " + hdr.type + " not known !"));
                }
                return;
            }
        }
        this.passUp(evt);
    }

    public boolean setProperties(Properties props) {
        super.setProperties(props);
        String str = props.getProperty("retransmit_timeout");
        if (str != null) {
            long[] tmp = Util.parseCommaDelimitedLongs(str);
            props.remove("retransmit_timeout");
            if (tmp != null && tmp.length > 0) {
                this.retransmit_timeout = tmp;
            }
        }
        if ((str = props.getProperty("gc_lag")) != null) {
            this.gc_lag = Integer.parseInt(str);
            if (this.gc_lag < 1) {
                System.err.println("NAKACK.setProperties(): gc_lag has to be at least 1");
                return false;
            }
            props.remove("gc_lag");
        }
        if ((str = props.getProperty("max_xmit_size")) != null) {
            this.max_xmit_size = Long.parseLong(str);
            props.remove("max_xmit_size");
        }
        if ((str = props.getProperty("use_mcast_xmit")) != null) {
            this.use_mcast_xmit = Boolean.valueOf(str);
            props.remove("use_mcast_xmit");
        }
        if ((str = props.getProperty("discard_delivered_msgs")) != null) {
            this.discard_delivered_msgs = Boolean.valueOf(str);
            props.remove("discard_delivered_msgs");
        }
        if (props.size() > 0) {
            System.err.println("NAKACK.setProperties(): these properties are not recognized:");
            props.list(System.out);
            return false;
        }
        return true;
    }

    long getNextSeqno() {
        return this.seqno++;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void send(Message msg) {
        long msg_id = this.getNextSeqno();
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("sending msg #" + msg_id));
        }
        msg.putHeader("NAKACK", new NakAckHeader(1, msg_id));
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("sent_msgs: " + this.printSentMsgs()));
        }
        TreeMap treeMap = this.sent_msgs;
        synchronized (treeMap) {
            this.sent_msgs.put(new Long(msg_id), msg);
        }
        this.passDown(new Event(1, msg));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleMessage(Message msg, NakAckHeader hdr) {
        Message msg_to_deliver;
        NakReceiverWindow win = null;
        if (msg == null || hdr == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"msg or header is null");
            }
            return;
        }
        Address sender = msg.getSrc();
        if (sender == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"sender of message is null");
            }
            return;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("[" + this.local_addr + "] received <" + sender + '#' + hdr.seqno + '>'));
        }
        HashMap hashMap = this.received_msgs;
        synchronized (hashMap) {
            win = (NakReceiverWindow)this.received_msgs.get(sender);
        }
        if (win == null) {
            if (this.leaving) {
                return;
            }
            if (this.log.isWarnEnabled()) {
                this.log.warn((Object)("[" + this.local_addr + "] discarded message from non-member " + sender));
            }
            return;
        }
        win.add(hdr.seqno, msg);
        msg = null;
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("receiver window for " + sender + " is: " + win));
        }
        while ((msg_to_deliver = win.remove()) != null) {
            this.passUp(new Event(1, msg_to_deliver));
            msg_to_deliver = null;
        }
    }

    void handleXmitReq(Address dest, long first_seqno, long last_seqno) {
        long size = 0L;
        long marker = first_seqno;
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)(this.local_addr + ": received xmit request for " + dest + " [" + first_seqno + " - " + last_seqno + ']'));
        }
        if (first_seqno > last_seqno) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("first_seqno (" + first_seqno + ") > last_seqno (" + last_seqno + "): not able to retransmit"));
            }
            return;
        }
        LinkedList<Message> list = new LinkedList<Message>();
        for (long i = first_seqno; i <= last_seqno; ++i) {
            Message m = (Message)this.sent_msgs.get(new Long(i));
            if (m == null) {
                if (!this.log.isErrorEnabled()) continue;
                this.log.error((Object)("(requester=" + dest + ", local_addr=" + this.local_addr + ") message with " + "seqno=" + i + " not found in sent_msgs ! sent_msgs=" + this.printSentMsgs()));
                continue;
            }
            long len = m.size();
            if ((size += len) > this.max_xmit_size && list.size() > 0) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("xmitting msgs [" + marker + '-' + (i - 1L) + "] to " + dest));
                }
                this.sendXmitRsp(dest, (LinkedList)list.clone(), marker, i - 1L);
                marker = i;
                list.clear();
                size = len;
            }
            Message tmp = m;
            tmp.setDest(dest);
            tmp.setSrc(this.local_addr);
            list.add(tmp);
        }
        if (list.size() > 0) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("xmitting msgs [" + marker + '-' + last_seqno + "] to " + dest));
            }
            this.sendXmitRsp(dest, (LinkedList)list.clone(), marker, last_seqno);
            list.clear();
        }
    }

    void sendXmitRsp(Address dest, LinkedList xmit_list, long first_seqno, long last_seqno) {
        if (xmit_list == null || xmit_list.size() == 0) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"xmit_list is empty");
            }
            return;
        }
        if (this.use_mcast_xmit) {
            dest = null;
        }
        Message msg = new Message(dest, null, xmit_list);
        msg.putHeader("NAKACK", new NakAckHeader(3, first_seqno, last_seqno));
        this.passDown(new Event(1, msg));
    }

    void handleXmitRsp(Message msg) {
        block6: {
            if (msg == null) {
                if (this.log.isWarnEnabled()) {
                    this.log.warn((Object)"message is null");
                }
                return;
            }
            try {
                LinkedList list = (LinkedList)msg.getObject();
                if (list != null) {
                    Iterator it = list.iterator();
                    while (it.hasNext()) {
                        Message m = (Message)it.next();
                        this.up(new Event(1, m));
                    }
                    list.clear();
                }
            }
            catch (Exception ex) {
                if (!this.log.isErrorEnabled()) break block6;
                this.log.error((Object)("message did not contain a list (LinkedList) of retransmitted messages: " + ex));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void adjustReceivers() {
        HashMap hashMap = this.received_msgs;
        synchronized (hashMap) {
            NakReceiverWindow win;
            Address sender;
            Iterator it = this.received_msgs.keySet().iterator();
            while (it.hasNext()) {
                sender = (Address)it.next();
                if (this.members.contains(sender)) continue;
                win = (NakReceiverWindow)this.received_msgs.get(sender);
                win.reset();
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("removing " + sender + " from received_msgs (not member anymore)"));
                }
                it.remove();
            }
            for (int i = 0; i < this.members.size(); ++i) {
                sender = (Address)this.members.elementAt(i);
                if (this.received_msgs.containsKey(sender)) continue;
                win = new NakReceiverWindow(sender, this, 0L, this.timer);
                win.setRetransmitTimeouts(this.retransmit_timeout);
                win.setDiscardDeliveredMessages(this.discard_delivered_msgs);
                this.received_msgs.put(sender, win);
            }
        }
    }

    Digest getDigest() {
        Digest digest = new Digest(this.members.size());
        for (int i = 0; i < this.members.size(); ++i) {
            Address sender = (Address)this.members.elementAt(i);
            Range range = this.getLowestAndHighestSeqno(sender, false);
            if (range == null) {
                if (!this.log.isErrorEnabled()) continue;
                this.log.error((Object)"range is null");
                continue;
            }
            digest.add(sender, range.low, range.high);
        }
        return digest;
    }

    Digest getDigestHighestDeliveredMsgs() {
        long high_seqno_seen = 0L;
        Digest digest = new Digest(this.members.size());
        for (int i = 0; i < this.members.size(); ++i) {
            Address sender = (Address)this.members.elementAt(i);
            Range range = this.getLowestAndHighestSeqno(sender, true);
            if (range == null) {
                if (!this.log.isErrorEnabled()) continue;
                this.log.error((Object)"range is null");
                continue;
            }
            high_seqno_seen = this.getHighSeqnoSeen(sender);
            digest.add(sender, range.low, range.high, high_seqno_seen);
        }
        return digest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setDigest(Digest d) {
        this.clear();
        if (d == null || d.senders == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"digest or digest.senders is null");
            }
            return;
        }
        for (int i = 0; i < d.size(); ++i) {
            Address sender = d.senderAt(i);
            if (sender == null) {
                if (!this.log.isErrorEnabled()) continue;
                this.log.error((Object)("sender at index " + i + " in digest is null"));
                continue;
            }
            long initial_seqno = d.highSeqnoAt(i);
            NakReceiverWindow win = new NakReceiverWindow(sender, this, initial_seqno, this.timer);
            win.setRetransmitTimeouts(this.retransmit_timeout);
            win.setDiscardDeliveredMessages(this.discard_delivered_msgs);
            HashMap hashMap = this.received_msgs;
            synchronized (hashMap) {
                this.received_msgs.put(sender, win);
                continue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void mergeDigest(Digest d) {
        if (d == null || d.senders == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"digest or digest.senders is null");
            }
            return;
        }
        for (int i = 0; i < d.size(); ++i) {
            Address sender = d.senderAt(i);
            if (sender == null) {
                if (!this.log.isErrorEnabled()) continue;
                this.log.error((Object)("sender at index " + i + " in digest is null"));
                continue;
            }
            long initial_seqno = d.highSeqnoAt(i);
            HashMap hashMap = this.received_msgs;
            synchronized (hashMap) {
                NakReceiverWindow win = (NakReceiverWindow)this.received_msgs.get(sender);
                if (win == null) {
                    win = new NakReceiverWindow(sender, this, initial_seqno, this.timer);
                    win.setRetransmitTimeouts(this.retransmit_timeout);
                    win.setDiscardDeliveredMessages(this.discard_delivered_msgs);
                    this.received_msgs.put(sender, win);
                } else if (win.getHighestReceived() < initial_seqno) {
                    win.reset();
                    this.received_msgs.remove(sender);
                    win = new NakReceiverWindow(sender, this, initial_seqno, this.timer);
                    win.setRetransmitTimeouts(this.retransmit_timeout);
                    win.setDiscardDeliveredMessages(this.discard_delivered_msgs);
                    this.received_msgs.put(sender, win);
                }
                continue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Range getLowestAndHighestSeqno(Address sender, boolean stop_at_gaps) {
        NakReceiverWindow win;
        Range r = null;
        if (sender == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"sender is null");
            }
            return r;
        }
        HashMap hashMap = this.received_msgs;
        synchronized (hashMap) {
            win = (NakReceiverWindow)this.received_msgs.get(sender);
        }
        if (win == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("sender " + sender + " not found in received_msgs"));
            }
            return r;
        }
        r = stop_at_gaps ? new Range(win.getLowestSeen(), win.getHighestSeen()) : new Range(win.getLowestSeen(), win.getHighestReceived() + 1L);
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getHighSeqnoSeen(Address sender) {
        NakReceiverWindow win;
        long ret = 0L;
        if (sender == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"sender is null");
            }
            return ret;
        }
        if (sender.equals(this.local_addr)) {
            return this.seqno - 1L;
        }
        HashMap hashMap = this.received_msgs;
        synchronized (hashMap) {
            win = (NakReceiverWindow)this.received_msgs.get(sender);
        }
        if (win == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("sender " + sender + " not found in received_msgs"));
            }
            return ret;
        }
        ret = win.getHighestReceived();
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stable(Digest d) {
        if (this.members == null || this.local_addr == null || d == null) {
            if (this.log.isWarnEnabled()) {
                this.log.warn((Object)"members, local_addr or digest are null !");
            }
            return;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("received digest " + d));
        }
        for (int i = 0; i < d.size(); ++i) {
            NakReceiverWindow recv_win;
            Address sender = d.senderAt(i);
            long seqno = d.highSeqnoAt(i);
            if (sender == null) continue;
            AbstractMap abstractMap = this.received_msgs;
            synchronized (abstractMap) {
                recv_win = (NakReceiverWindow)this.received_msgs.get(sender);
            }
            if (recv_win != null) {
                long my_highest_rcvd = recv_win.getHighestReceived();
                long stability_highest_rcvd = d.highSeqnoSeenAt(i);
                if (stability_highest_rcvd >= 0L && stability_highest_rcvd > my_highest_rcvd) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("my_highest_rcvd (" + my_highest_rcvd + ") < stability_highest_rcvd (" + stability_highest_rcvd + "): requesting retransmission of " + sender + '#' + stability_highest_rcvd));
                    }
                    this.retransmit(stability_highest_rcvd, stability_highest_rcvd, sender);
                }
            }
            if ((seqno -= (long)this.gc_lag) < 0L) continue;
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("deleting msgs <= " + seqno + " from " + sender));
            }
            if (sender.equals(this.local_addr)) {
                abstractMap = this.sent_msgs;
                synchronized (abstractMap) {
                    SortedMap stable_keys = this.sent_msgs.headMap(new Long(seqno));
                    if (stable_keys != null) {
                        stable_keys.clear();
                    }
                }
            }
            if (recv_win == null) continue;
            recv_win.stable(seqno);
        }
    }

    public synchronized void retransmit(long first_seqno, long last_seqno, Address sender) {
        Message retransmit_msg = new Message(sender, null, null);
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)(this.local_addr + ": sending XMIT_REQ ([" + first_seqno + ", " + last_seqno + "]) to " + sender));
        }
        NakAckHeader hdr = new NakAckHeader(2, first_seqno, last_seqno);
        retransmit_msg.putHeader("NAKACK", hdr);
        this.passDown(new Event(1, retransmit_msg));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clear() {
        HashMap hashMap = this.received_msgs;
        synchronized (hashMap) {
            Iterator it = this.received_msgs.values().iterator();
            while (it.hasNext()) {
                NakReceiverWindow win = (NakReceiverWindow)it.next();
                win.reset();
            }
            this.received_msgs.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeAll() {
        if (this.log.isDebugEnabled() && this.sent_msgs.size() > 0 && this.received_msgs.size() > 0) {
            String contents = this.dumpContents();
            this.log.debug((Object)("contents for " + this.local_addr + ":\n" + contents));
        }
        AbstractMap abstractMap = this.sent_msgs;
        synchronized (abstractMap) {
            this.sent_msgs.clear();
        }
        abstractMap = this.received_msgs;
        synchronized (abstractMap) {
            Iterator it = this.received_msgs.values().iterator();
            while (it.hasNext()) {
                NakReceiverWindow win = (NakReceiverWindow)it.next();
                win.destroy();
            }
            this.received_msgs.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String dumpContents() {
        StringBuffer ret = new StringBuffer();
        ret.append("\nsent_msgs: " + this.printSentMsgs());
        ret.append("\nreceived_msgs:\n");
        HashMap hashMap = this.received_msgs;
        synchronized (hashMap) {
            Iterator it = this.received_msgs.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                Address addr = (Address)entry.getKey();
                Object w = entry.getValue();
                ret.append(addr).append(": ").append(w.toString()).append('\n');
            }
        }
        return ret.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String printSentMsgs() {
        Long max_seqno;
        Long min_seqno;
        StringBuffer sb = new StringBuffer();
        TreeMap treeMap = this.sent_msgs;
        synchronized (treeMap) {
            min_seqno = this.sent_msgs.size() > 0 ? (Long)this.sent_msgs.firstKey() : new Long(0L);
            max_seqno = this.sent_msgs.size() > 0 ? (Long)this.sent_msgs.lastKey() : new Long(0L);
        }
        sb.append('[').append(min_seqno).append(" - ").append(max_seqno).append(']');
        return sb.toString();
    }

    void handleConfigEvent(HashMap map) {
        if (map == null) {
            return;
        }
        if (map.containsKey("frag_size")) {
            this.max_xmit_size = ((Integer)map.get("frag_size")).intValue();
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)("max_xmit_size=" + this.max_xmit_size));
            }
        }
    }
}

