/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;

public class MysqlTest {
    static final String read_query = "select value from counter where id=1";
    static final String write_query = "update counter set value=20 where id=1";
    static final String reset_query = "update counter set value=10 where id=1";
    long start = 0L;
    static Map isolation_levels = new HashMap();

    public static void main(String[] args) {
        int isolation_level = 8;
        boolean write = false;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-write")) {
                write = true;
                continue;
            }
            if (args[i].equals("-isolation_level")) {
                isolation_level = MysqlTest.stringToIsolationLevel(args[++i]);
                continue;
            }
            if (args[i].equals("-reset")) {
                try {
                    new MysqlTest().reset();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                continue;
            }
            MysqlTest.help();
            return;
        }
        try {
            Class.forName("com.mysql.jdbc.Driver").newInstance();
            new MysqlTest().start(isolation_level, write);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static int stringToIsolationLevel(String arg) {
        if (arg == null) {
            throw new IllegalArgumentException();
        }
        Integer retval = (Integer)isolation_levels.get(arg = arg.trim().toLowerCase());
        if (retval == null) {
            throw new IllegalArgumentException("valid values are " + isolation_levels.keySet());
        }
        return retval;
    }

    static void help() {
        System.out.println("MysqlTest [-write] [-isolation_level <level>] [-reset] [-help]");
    }

    private Connection getConnection(int isolation_level) throws SQLException {
        Connection c = DriverManager.getConnection("jdbc:mysql://localhost/test?user=bela");
        int tmp = c.getTransactionIsolation();
        System.out.println("old isolation level is " + this.printIsolationLevel(tmp));
        c.setTransactionIsolation(isolation_level);
        tmp = c.getTransactionIsolation();
        System.out.println("new isolation level is " + this.printIsolationLevel(tmp));
        c.setAutoCommit(false);
        System.out.println("auto-commit=" + c.getAutoCommit());
        return c;
    }

    private String printIsolationLevel(int isolation_level) {
        switch (isolation_level) {
            case 0: {
                return "NONE";
            }
            case 1: {
                return "READ_UNCOMMITTED";
            }
            case 2: {
                return "READ_COMMITTED";
            }
            case 4: {
                return "REPEATABLE_READ";
            }
            case 8: {
                return "SERIALIZABLE";
            }
        }
        return "<unknown>";
    }

    private void start(int isolation_level, boolean write) throws SQLException {
        Connection conn = this.getConnection(isolation_level);
        if (write) {
            this.write(conn);
        } else {
            this.read(conn);
        }
        this.log("committing TX");
        conn.commit();
        conn.close();
    }

    void write(Connection conn) throws SQLException {
        Statement stmt = conn.createStatement();
        this.log("writing value");
        int num_rows_updated = stmt.executeUpdate(write_query);
        this.log("write done, updated " + num_rows_updated + " rows");
        stmt.close();
        this.sleep(10000L);
    }

    void read(Connection conn) throws SQLException {
        Statement stmt = conn.createStatement();
        ResultSet rs = null;
        for (int i = 0; i < 5; ++i) {
            rs = stmt.executeQuery("SELECT value from counter where id=1");
            rs.next();
            int value = rs.getInt("value");
            this.log("value=" + value);
            this.sleep(3000L);
        }
        rs.close();
        stmt.close();
    }

    void reset() throws SQLException {
        Connection conn = this.getConnection(8);
        conn.setAutoCommit(true);
        Statement stmt = conn.createStatement();
        stmt.executeUpdate(reset_query);
        stmt.close();
        conn.close();
    }

    void sleep(long timeout) {
        try {
            Thread.sleep(timeout);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    void log(String s) {
        if (this.start == 0L) {
            this.start = System.currentTimeMillis();
        }
        long now = System.currentTimeMillis();
        System.out.println("[" + Thread.currentThread().getName() + "] [" + (now - this.start) + "] " + s);
    }

    static {
        isolation_levels.put("none", new Integer(0));
        isolation_levels.put("read_uncommitted", new Integer(1));
        isolation_levels.put("read_committed", new Integer(2));
        isolation_levels.put("repeatable_read", new Integer(4));
        isolation_levels.put("serializable", new Integer(8));
    }
}

