/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests.perf;

import java.io.BufferedReader;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jgroups.tests.perf.Data;
import org.jgroups.tests.perf.MemberInfo;
import org.jgroups.tests.perf.Receiver;
import org.jgroups.tests.perf.Transport;
import org.jgroups.util.Util;

public class Test
implements Receiver {
    String props = null;
    Properties config;
    boolean sender = false;
    Transport transport = null;
    Object local_addr = null;
    HashMap senders = new HashMap();
    ArrayList members = new ArrayList();
    long start = 0L;
    long stop = 0L;
    int num_members = 0;
    Log log = LogFactory.getLog(this.getClass());
    boolean all_received = false;
    HashMap results = new HashMap();
    boolean gnuplot_output = false;
    long log_interval = 1000L;
    long last_dump = 0L;
    long counter = 1L;
    long msg_size = 1000L;

    public void start(Properties c, boolean silent) throws Exception {
        String line;
        String config_file = "config.txt";
        Properties tmp = new Properties();
        config_file = c.getProperty("config");
        BufferedReader fileReader = new BufferedReader(new FileReader(config_file));
        while ((line = fileReader.readLine()) != null) {
            if (line.startsWith("#") || (line = line.trim()).length() == 0) continue;
            StringTokenizer st = new StringTokenizer(line, "=", false);
            String key = st.nextToken().toLowerCase();
            String val = st.nextToken();
            tmp.put(key, val);
        }
        fileReader.close();
        tmp.putAll((Map<?, ?>)c);
        this.config = tmp;
        StringBuffer sb = new StringBuffer();
        sb.append("\n\n----------------------- TEST -----------------------\n");
        sb.append("Date: ").append(new Date()).append('\n');
        sb.append("Run by: ").append(System.getProperty("user.name")).append("\n\n");
        sb.append("Properties: ").append(this.printProperties()).append("\n-------------------------\n\n");
        Iterator<Map.Entry<Object, Object>> it = this.config.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Object, Object> entry = it.next();
            sb.append(entry.getKey()).append(":\t").append(entry.getValue()).append('\n');
        }
        sb.append('\n');
        if (!silent) {
            System.out.println("Configuration is: " + sb);
        }
        this.log.info((Object)sb.toString());
        this.props = this.config.getProperty("props");
        this.num_members = Integer.parseInt(this.config.getProperty("num_members"));
        this.sender = Boolean.valueOf(this.config.getProperty("sender"));
        this.msg_size = Long.parseLong(this.config.getProperty("msg_size"));
        String tmp2 = this.config.getProperty("gnuplot_output", "false");
        if (Boolean.valueOf(tmp2).booleanValue()) {
            this.gnuplot_output = true;
        }
        if ((tmp2 = this.config.getProperty("log_interval")) != null) {
            this.log_interval = Long.parseLong(tmp2);
        }
        if (this.gnuplot_output) {
            sb = new StringBuffer();
            sb.append("\n##### msgs_received");
            sb.append(", free_mem [KB] ");
            sb.append(", total_mem [KB] ");
            sb.append(", total_msgs_sec [msgs/sec] ");
            sb.append(", total_throughput [KB/sec] ");
            sb.append(", rolling_msgs_sec (last ").append(this.log_interval).append(" msgs) ");
            sb.append(" [msgs/sec] ");
            sb.append(", rolling_throughput (last ").append(this.log_interval).append(" msgs) ");
            sb.append(" [KB/sec]\n");
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)sb.toString());
            }
        }
        String transport_name = this.config.getProperty("transport");
        this.transport = (Transport)Thread.currentThread().getContextClassLoader().loadClass(transport_name).newInstance();
        this.transport.create(this.config);
        this.transport.setReceiver(this);
        this.transport.start();
        this.local_addr = this.transport.getLocalAddress();
    }

    private String printProperties() {
        StringBuffer sb = new StringBuffer();
        Properties p = System.getProperties();
        Iterator<Map.Entry<Object, Object>> it = p.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Object, Object> entry = it.next();
            sb.append(entry.getKey()).append(": ").append(entry.getValue()).append('\n');
        }
        return sb.toString();
    }

    public void stop() {
        if (this.transport != null) {
            this.transport.stop();
            this.transport.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receive(Object sender, byte[] payload) {
        try {
            Data d = (Data)Util.objectFromByteBuffer(payload);
            switch (d.getType()) {
                case 1: {
                    this.sendDiscoveryResponse();
                    break;
                }
                case 2: {
                    ArrayList arrayList = this.members;
                    synchronized (arrayList) {
                        if (!this.members.contains(sender)) {
                            this.members.add(sender);
                            System.out.println("-- " + sender + " joined");
                            if (d.sender) {
                                ArrayList arrayList2 = this.members;
                                synchronized (arrayList2) {
                                    if (!this.senders.containsKey(sender)) {
                                        this.senders.put(sender, new MemberInfo(d.num_msgs));
                                    }
                                }
                            }
                            this.members.notify();
                        }
                        break;
                    }
                }
                case 3: {
                    MemberInfo info;
                    if (this.all_received) {
                        return;
                    }
                    if (this.start == 0L) {
                        this.last_dump = this.start = System.currentTimeMillis();
                    }
                    if ((info = (MemberInfo)this.senders.get(sender)) != null) {
                        if (info.start == 0L) {
                            info.start = System.currentTimeMillis();
                        }
                        ++info.num_msgs_received;
                        ++this.counter;
                        info.total_bytes_received += (long)d.payload.length;
                        if (info.num_msgs_received % 1000L == 0L) {
                            System.out.println("-- received " + info.num_msgs_received + " messages from " + sender);
                        }
                        if (this.counter % this.log_interval == 0L && this.log.isInfoEnabled()) {
                            this.log.info((Object)this.dumpStats(this.counter));
                        }
                        if (info.num_msgs_received >= info.num_msgs_expected) {
                            info.done = true;
                            if (info.stop == 0L) {
                                info.stop = System.currentTimeMillis();
                            }
                            if (this.allReceived()) {
                                this.all_received = true;
                                if (this.stop == 0L) {
                                    this.stop = System.currentTimeMillis();
                                }
                                this.sendResults();
                                if (!this.sender) {
                                    this.dumpSenders();
                                }
                                Test test = this;
                                synchronized (test) {
                                    this.notify();
                                }
                            }
                        }
                        break;
                    }
                    System.err.println("-- sender " + sender + " not found in senders hashmap");
                    break;
                }
                case 4: {
                    if (this.all_received) {
                        return;
                    }
                    MemberInfo mi = (MemberInfo)this.senders.get(sender);
                    if (mi != null) {
                        mi.done = true;
                        if (mi.stop == 0L) {
                            mi.stop = System.currentTimeMillis();
                        }
                        if (this.allReceived()) {
                            this.all_received = true;
                            if (this.stop == 0L) {
                                this.stop = System.currentTimeMillis();
                            }
                            this.sendResults();
                            if (!this.sender) {
                                this.dumpSenders();
                            }
                            Test test = this;
                            synchronized (test) {
                                this.notify();
                            }
                        }
                        break;
                    }
                    System.err.println("-- sender " + sender + " not found in senders hashmap");
                    break;
                }
                case 5: {
                    HashMap hashMap = this.results;
                    synchronized (hashMap) {
                        if (!this.results.containsKey(sender)) {
                            this.results.put(sender, d.results);
                            this.results.notify();
                        }
                        break;
                    }
                }
                default: {
                    System.err.println("received invalid data type: " + payload[0]);
                    break;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void sendResults() throws Exception {
        Data d = new Data(5);
        d.results = (HashMap)this.senders.clone();
        byte[] buf = Util.objectToByteBuffer(d);
        this.transport.send(null, buf);
    }

    boolean allReceived() {
        Iterator it = this.senders.values().iterator();
        while (it.hasNext()) {
            MemberInfo mi = (MemberInfo)it.next();
            if (mi.done) continue;
            return false;
        }
        return true;
    }

    void sendMessages() throws Exception {
        long total_msgs = 0L;
        int msg_size = Integer.parseInt(this.config.getProperty("msg_size"));
        int num_msgs = Integer.parseInt(this.config.getProperty("num_msgs"));
        int log_interval = Integer.parseInt(this.config.getProperty("log_interval"));
        byte[] buf = new byte[msg_size];
        for (int k = 0; k < msg_size; ++k) {
            buf[k] = 46;
        }
        Data d = new Data(3);
        d.payload = buf;
        byte[] payload = Util.objectToByteBuffer(d);
        for (int i = 0; i < num_msgs; ++i) {
            this.transport.send(null, payload);
            if (++total_msgs % 1000L == 0L) {
                System.out.println("++ sent " + total_msgs);
            }
            if (total_msgs % (long)log_interval != 0L) continue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fetchResults() throws Exception {
        System.out.println("-- sent all messages. Asking receivers if they received all messages\n");
        int expected_responses = this.members.size();
        Data d2 = new Data(4);
        byte[] tmp = Util.objectToByteBuffer(d2);
        System.out.println("-- fetching results (from " + expected_responses + " members)");
        HashMap hashMap = this.results;
        synchronized (hashMap) {
            while (this.results.size() < expected_responses) {
                this.transport.send(null, tmp);
                this.results.wait(1000L);
            }
        }
        System.out.println("-- received all responses");
    }

    void dumpResults() {
        StringBuffer sb = new StringBuffer();
        sb.append("\n-- results:\n\n");
        Iterator it = this.results.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            Object member = entry.getKey();
            HashMap map = (HashMap)entry.getValue();
            sb.append("-- results from ").append(member).append(":\n");
            this.dump(map, sb);
            sb.append('\n');
        }
        System.out.println(sb.toString());
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)sb.toString());
        }
    }

    void dumpSenders() {
        StringBuffer sb = new StringBuffer();
        this.dump(this.senders, sb);
        System.out.println(sb.toString());
    }

    void dump(HashMap map, StringBuffer sb) {
        MemberInfo combined = new MemberInfo(0L);
        combined.start = Long.MAX_VALUE;
        combined.stop = Long.MIN_VALUE;
        Iterator it2 = map.entrySet().iterator();
        while (it2.hasNext()) {
            Map.Entry entry = it2.next();
            Object sender = entry.getKey();
            MemberInfo mi = (MemberInfo)entry.getValue();
            combined.start = Math.min(combined.start, mi.start);
            combined.stop = Math.max(combined.stop, mi.stop);
            combined.num_msgs_expected += mi.num_msgs_expected;
            combined.num_msgs_received += mi.num_msgs_received;
            combined.total_bytes_received += mi.total_bytes_received;
            sb.append("sender: ").append(sender).append(": ").append(mi).append('\n');
        }
        sb.append("\ncombined: ").append(combined).append('\n');
    }

    String dumpStats(long received_msgs) {
        StringBuffer sb = new StringBuffer();
        if (this.gnuplot_output) {
            sb.append(received_msgs).append(' ');
        } else {
            sb.append("\nmsgs_received=").append(received_msgs);
        }
        if (this.gnuplot_output) {
            sb.append((double)Runtime.getRuntime().freeMemory() / 1000.0).append(' ');
        } else {
            sb.append(", free_mem=").append((double)Runtime.getRuntime().freeMemory() / 1000.0);
        }
        if (this.gnuplot_output) {
            sb.append((double)Runtime.getRuntime().totalMemory() / 1000.0).append(' ');
        } else {
            sb.append(", total_mem=").append((double)Runtime.getRuntime().totalMemory() / 1000.0).append('\n');
        }
        this.dumpThroughput(sb, received_msgs);
        return sb.toString();
    }

    void dumpThroughput(StringBuffer sb, long received_msgs) {
        long current = System.currentTimeMillis();
        double tmp = 1000L * received_msgs / (current - this.start);
        if (this.gnuplot_output) {
            sb.append(tmp).append(' ');
        } else {
            sb.append("total_msgs_sec=").append(tmp).append(" [msgs/sec]");
        }
        tmp = received_msgs * this.msg_size / (current - this.start);
        if (this.gnuplot_output) {
            sb.append(tmp).append(' ');
        } else {
            sb.append("\ntotal_throughput=").append(tmp).append(" [KB/sec]");
        }
        tmp = 1000L * this.log_interval / (current - this.last_dump);
        if (this.gnuplot_output) {
            sb.append(tmp).append(' ');
        } else {
            sb.append("\nrolling_msgs_sec (last ").append(this.log_interval).append(" msgs)=");
            sb.append(tmp).append(" [msgs/sec]");
        }
        tmp = this.log_interval * this.msg_size / (current - this.last_dump);
        if (this.gnuplot_output) {
            sb.append(tmp).append(' ');
        } else {
            sb.append("\nrolling_throughput (last ").append(this.log_interval).append(" msgs)=");
            sb.append(tmp).append(" [KB/sec]\n");
        }
        this.last_dump = current;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void runDiscoveryPhase() throws Exception {
        Data d = new Data(1);
        this.transport.send(null, Util.objectToByteBuffer(d));
        this.sendDiscoveryResponse();
        ArrayList arrayList = this.members;
        synchronized (arrayList) {
            System.out.println("-- waiting for " + this.num_members + " members to join");
            while (this.members.size() < this.num_members) {
                this.members.wait();
                System.out.println("-- members: " + this.members.size());
            }
        }
    }

    void sendDiscoveryResponse() throws Exception {
        Data d2 = new Data(2);
        if (this.sender) {
            d2.sender = true;
            d2.num_msgs = Long.parseLong(this.config.getProperty("num_msgs"));
        }
        this.transport.send(null, Util.objectToByteBuffer(d2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        block16: {
            Properties config = new Properties();
            boolean sender = false;
            boolean silent = false;
            Test t = null;
            for (int i = 0; i < args.length; ++i) {
                if ("-sender".equals(args[i])) {
                    config.put("sender", "true");
                    sender = true;
                    continue;
                }
                if ("-receiver".equals(args[i])) {
                    config.put("sender", "false");
                    sender = false;
                    continue;
                }
                if ("-config".equals(args[i])) {
                    String config_file = args[++i];
                    config.put("config", config_file);
                    continue;
                }
                if ("-props".equals(args[i])) {
                    String props = args[++i];
                    config.put("props", props);
                    continue;
                }
                if ("-silent".equals(args[i])) {
                    silent = true;
                    continue;
                }
                Test.help();
                return;
            }
            try {
                t = new Test();
                t.start(config, silent);
                t.runDiscoveryPhase();
                if (sender) {
                    t.sendMessages();
                    t.fetchResults();
                    t.dumpResults();
                    break block16;
                }
                Test i = t;
                synchronized (i) {
                    t.wait();
                }
                Util.sleep(2000L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (t != null) {
                    t.stop();
                }
            }
        }
    }

    static void help() {
        System.out.println("Test [-help] ([-sender] | [-receiver]) [-config <config file>] [-props <stack config>] [-silent]");
    }
}

