/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.hibernate3.dao.impl;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.cfg.Configuration;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.MethodNotFoundRuntimeException;
import org.seasar.framework.beans.factory.BeanDescFactory;
import org.seasar.framework.util.FieldUtil;
import org.seasar.framework.util.MethodUtil;
import org.seasar.framework.util.ResourceUtil;
import org.seasar.framework.util.StringUtil;
import org.seasar.hibernate3.S2SessionFactory;
import org.seasar.hibernate3.dao.HibernateCommand;
import org.seasar.hibernate3.dao.HibernateDaoMetaData;
import org.seasar.hibernate3.dao.impl.ArgsMetaData;
import org.seasar.hibernate3.dao.impl.AutoArgsQueryCommand;
import org.seasar.hibernate3.dao.impl.DeleteCommand;
import org.seasar.hibernate3.dao.impl.HqlQueryCommand;
import org.seasar.hibernate3.dao.impl.LoadCommand;
import org.seasar.hibernate3.dao.impl.NamedQueryCommand;
import org.seasar.hibernate3.dao.impl.SaveCommand;
import org.seasar.hibernate3.dao.impl.SaveOrUpdateCommand;
import org.seasar.hibernate3.dao.impl.UpdateCommand;

public class HibernateDaoMetaDataImpl
implements HibernateDaoMetaData {
    private static final String[] INSERT_NAMES = new String[]{"insert", "create", "add", "save"};
    private static final String[] UPDATE_NAMES = new String[]{"update", "merge"};
    private static final String[] DELETE_NAMES = new String[]{"delete", "remove"};
    private static final String[] SAVE_OR_UPDATE_NAMES = new String[]{"saveOrUpdate"};
    private static final String[] LOAD_NAMES = new String[]{"load"};
    private Class daoClass_;
    private BeanDesc daoBeanDesc_;
    private Class beanClass_;
    private Map hibernateCommands_ = new HashMap();
    private S2SessionFactory s2sessionFactory_;
    private Map namedQueries_;

    public HibernateDaoMetaDataImpl(S2SessionFactory s2sessionFactory, Class daoClass) {
        this.s2sessionFactory_ = s2sessionFactory;
        this.daoClass_ = daoClass;
        this.daoBeanDesc_ = BeanDescFactory.getBeanDesc((Class)daoClass);
        Field beanField = this.daoBeanDesc_.getField("BEAN");
        this.beanClass_ = (Class)FieldUtil.get((Field)beanField, null);
        this.setupHibernateNamedQuerys();
        this.setupHibernateCommand();
    }

    private void setupHibernateNamedQuerys() {
        Configuration cfg = new Configuration();
        String hibernateConfigPath = this.s2sessionFactory_.getConfigPath();
        cfg.configure(ResourceUtil.getResource((String)hibernateConfigPath));
        this.namedQueries_ = cfg.getNamedQueries();
    }

    private void setupHibernateCommand() {
        String[] names = this.daoBeanDesc_.getMethodNames();
        int i = 0;
        while (i < names.length) {
            Method[] methods = this.daoBeanDesc_.getMethods(names[i]);
            if (methods.length == 1 && MethodUtil.isAbstract((Method)methods[0])) {
                this.setupMethod(methods[0]);
            }
            ++i;
        }
    }

    private void setupMethod(Method method) {
        String methodName = method.getName();
        if (this.isMethod(SAVE_OR_UPDATE_NAMES, methodName)) {
            this.setupSaveOrUpdateMethodByAuto(method);
        } else if (this.isMethod(INSERT_NAMES, methodName)) {
            this.setupInsertMethodByAuto(method);
        } else if (this.isMethod(UPDATE_NAMES, methodName)) {
            this.setupUpdateMethodByAuto(method);
        } else if (this.isMethod(DELETE_NAMES, methodName)) {
            this.setupDeleteMethodByAuto(method);
        } else if (this.isMethod(LOAD_NAMES, methodName)) {
            this.setupLoadMethodByAuto(method);
        } else {
            this.setupSelectMethod(method);
        }
    }

    private boolean isMethod(String[] methodNameList, String methodName) {
        int i = 0;
        while (i < methodNameList.length) {
            if (methodName.startsWith(methodNameList[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void setupSelectMethod(Method method) {
        String namedQueryLongPath = String.valueOf(this.daoClass_.getName()) + "_" + method.getName();
        String namedQueryShortPath = method.getName();
        String hqlQuery = this.getQuery(method.getName());
        if (hqlQuery != "") {
            this.setupSelectMethodByHql(method);
        } else if (this.isNamedQuery(namedQueryLongPath)) {
            this.setupSelectMethodByNamedQuery(method, namedQueryLongPath);
        } else if (this.isNamedQuery(namedQueryShortPath)) {
            this.setupSelectMethodByNamedQuery(method, namedQueryShortPath);
        } else {
            this.setupSelectMethodByAuto(method);
        }
    }

    private boolean isNamedQuery(String namedQueryName) {
        return this.namedQueries_.containsKey(namedQueryName);
    }

    private String[] getArgNames(String methodName) {
        return this.getSuffixValues(methodName, "_ARGS");
    }

    private String[] getPropertyNames(String methodName) {
        return this.getSuffixValues(methodName, "_PROPERTY");
    }

    private String getQuery(String methodName) {
        return this.getSuffixValue(methodName, "_HQL");
    }

    private String getLockMode(String methodName) {
        return this.getSuffixValue(methodName, "_LOCK");
    }

    private String[] getEager(String methodName) {
        return this.getSuffixValues(methodName, "_EAGER");
    }

    private String getSuffixValue(String methodName, String suffix) {
        String queryKey = String.valueOf(methodName) + suffix;
        if (this.daoBeanDesc_.hasField(queryKey)) {
            Field queryNamesField = this.daoBeanDesc_.getField(queryKey);
            return (String)FieldUtil.get((Field)queryNamesField, null);
        }
        return "";
    }

    private String[] getSuffixValues(String methodName, String suffix) {
        String value = this.getSuffixValue(methodName, suffix);
        if (value.equals("")) {
            return new String[0];
        }
        return StringUtil.split((String)value, (String)",");
    }

    private void setupInsertMethodByAuto(Method method) {
        SaveCommand cmd = new SaveCommand(this.s2sessionFactory_);
        this.hibernateCommands_.put(method.getName(), cmd);
    }

    private void setupSaveOrUpdateMethodByAuto(Method method) {
        SaveOrUpdateCommand cmd = new SaveOrUpdateCommand(this.s2sessionFactory_);
        this.hibernateCommands_.put(method.getName(), cmd);
    }

    private void setupUpdateMethodByAuto(Method method) {
        UpdateCommand cmd = new UpdateCommand(this.s2sessionFactory_);
        this.hibernateCommands_.put(method.getName(), cmd);
    }

    private void setupDeleteMethodByAuto(Method method) {
        DeleteCommand cmd = new DeleteCommand(this.s2sessionFactory_);
        this.hibernateCommands_.put(method.getName(), cmd);
    }

    private void setupSelectMethodByHql(Method method) {
        HqlQueryCommand cmd = new HqlQueryCommand(this.s2sessionFactory_, this.beanClass_, method);
        cmd.setArgsMeta(new ArgsMetaData(method, this.getArgNames(method.getName()), null));
        cmd.setHqlQuery(this.getQuery(method.getName()));
        this.hibernateCommands_.put(method.getName(), cmd);
    }

    private void setupSelectMethodByAuto(Method method) {
        String[] argNames = this.getArgNames(method.getName());
        AutoArgsQueryCommand cmd = new AutoArgsQueryCommand(this.s2sessionFactory_, this.beanClass_, method);
        cmd.setArgsMeta(new ArgsMetaData(method, argNames, this.getPropertyNames(method.getName())));
        cmd.setEagerFields(this.getEager(method.getName()));
        cmd.buildCriterionList();
        this.hibernateCommands_.put(method.getName(), cmd);
    }

    private void setupSelectMethodByNamedQuery(Method method, String namedQueryPath) {
        NamedQueryCommand cmd = new NamedQueryCommand(this.s2sessionFactory_, this.beanClass_, method);
        cmd.setArgsMeta(new ArgsMetaData(method, this.getArgNames(method.getName()), null));
        cmd.setNamedQueryPath(namedQueryPath);
        this.hibernateCommands_.put(method.getName(), cmd);
    }

    private void setupLoadMethodByAuto(Method method) {
        LoadCommand cmd = new LoadCommand(this.s2sessionFactory_, this.beanClass_, method);
        cmd.setLockMode(this.getLockMode(method.getName()));
        this.hibernateCommands_.put(method.getName(), cmd);
    }

    public Class getBeanClass() {
        return this.beanClass_;
    }

    public boolean hasHibernateCommand(String methodName) {
        return (HibernateCommand)this.hibernateCommands_.get(methodName) != null;
    }

    public HibernateCommand getHibernateCommand(String methodName) throws MethodNotFoundRuntimeException {
        return (HibernateCommand)this.hibernateCommands_.get(methodName);
    }
}

