/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.buffer;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.renderkit.html.HtmlResponseWriterImpl;

public class HtmlBufferResponseWriterWrapper
extends HtmlResponseWriterImpl {
    private ByteArrayOutputStream stream;
    private PrintWriter writer;

    public static HtmlBufferResponseWriterWrapper getInstance(ResponseWriter initialWriter) {
        ByteArrayOutputStream instanceStream = new ByteArrayOutputStream();
        PrintWriter instanceWriter = new PrintWriter(instanceStream, true);
        return new HtmlBufferResponseWriterWrapper(initialWriter, instanceStream, instanceWriter);
    }

    private HtmlBufferResponseWriterWrapper(ResponseWriter initialWriter, ByteArrayOutputStream stream, PrintWriter writer) {
        super(writer, initialWriter == null ? null : initialWriter.getContentType(), initialWriter == null ? null : initialWriter.getCharacterEncoding());
        this.stream = stream;
        this.writer = writer;
    }

    public String toString() {
        try {
            this.stream.flush();
            this.writer.close();
            return this.stream.toString(this.getCharacterEncoding());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("ResponseWriter accepted invalid character encoding " + this.getCharacterEncoding());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

