/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.renderkit.html.ext;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.UISelectBoolean;
import javax.faces.component.UISelectMany;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.model.SelectItem;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.component.DisplayValueOnlyCapable;
import org.apache.myfaces.component.UserRoleUtils;
import org.apache.myfaces.component.html.ext.HtmlSelectManyCheckbox;
import org.apache.myfaces.custom.checkbox.HtmlCheckbox;
import org.apache.myfaces.renderkit.RendererUtils;
import org.apache.myfaces.renderkit.html.HTML;
import org.apache.myfaces.renderkit.html.HtmlCheckboxRendererBase;
import org.apache.myfaces.renderkit.html.HtmlRendererUtils;

public class HtmlCheckboxRenderer
extends HtmlCheckboxRendererBase {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$myfaces$renderkit$html$ext$HtmlCheckboxRenderer == null ? (class$org$apache$myfaces$renderkit$html$ext$HtmlCheckboxRenderer = HtmlCheckboxRenderer.class$("org.apache.myfaces.renderkit.html.ext.HtmlCheckboxRenderer")) : class$org$apache$myfaces$renderkit$html$ext$HtmlCheckboxRenderer));
    private static final String PAGE_DIRECTION = "pageDirection";
    private static final String LINE_DIRECTION = "lineDirection";
    private static final String LAYOUT_SPREAD = "spread";
    static /* synthetic */ Class class$org$apache$myfaces$renderkit$html$ext$HtmlCheckboxRenderer;

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (component == null) {
            throw new NullPointerException("component");
        }
        if (component instanceof HtmlCheckbox) {
            this.renderSingleCheckbox(context, (HtmlCheckbox)component);
        } else if (component instanceof DisplayValueOnlyCapable && HtmlRendererUtils.isDisplayValueOnly(component)) {
            HtmlRendererUtils.renderDisplayValueOnlyForSelects(context, component);
        } else if (component instanceof UISelectMany) {
            String layout = this.getLayout((UISelectMany)component);
            if (layout != null && layout.equals(LAYOUT_SPREAD)) {
                return;
            }
            super.encodeEnd(context, component);
        } else if (component instanceof UISelectBoolean) {
            super.encodeEnd(context, component);
        } else {
            throw new IllegalArgumentException("Unsupported component class " + component.getClass().getName());
        }
    }

    public void renderCheckboxList(FacesContext facesContext, UISelectMany selectMany) throws IOException {
        String layout = this.getLayout(selectMany);
        if (layout != null) {
            Converter converter = this.getConverter(facesContext, selectMany);
            if (layout.equals(PAGE_DIRECTION)) {
                this.renderCheckboxListVertically(facesContext, selectMany, converter);
            } else if (layout.equals(LINE_DIRECTION)) {
                this.renderCheckboxListHorizontally(facesContext, selectMany, converter);
            } else {
                log.error((Object)("Wrong layout attribute for component " + selectMany.getClientId(facesContext) + ": " + layout));
            }
        }
    }

    protected void renderCheckboxListHorizontally(FacesContext facesContext, UISelectMany selectMany, Converter converter) throws IOException {
        boolean useSubmittedValues;
        Set lookupSet = RendererUtils.getSubmittedValuesAsSet(facesContext, selectMany, converter, selectMany);
        boolean bl = useSubmittedValues = lookupSet != null;
        if (!useSubmittedValues) {
            lookupSet = RendererUtils.getSelectedValuesAsSet(facesContext, selectMany, converter, selectMany);
        }
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.startElement("table", selectMany);
        HtmlRendererUtils.renderHTMLAttributes(writer, selectMany, HTML.SELECT_TABLE_PASSTHROUGH_ATTRIBUTES);
        HtmlRendererUtils.writeIdIfNecessary(writer, selectMany, facesContext);
        int numRows = this.getLayoutWidth(selectMany);
        for (int i = 0; i < numRows; ++i) {
            this.renderRowForHorizontal(facesContext, selectMany, converter, lookupSet, writer, numRows, i);
        }
        writer.endElement("table");
    }

    protected void renderRowForHorizontal(FacesContext facesContext, UISelectMany selectMany, Converter converter, Set lookupSet, ResponseWriter writer, int totalRows, int rowNum) throws IOException {
        writer.startElement("tr", selectMany);
        int colNum = 0;
        List items = RendererUtils.getSelectItemList(selectMany);
        for (int count = rowNum; count < items.size(); ++count) {
            int mod = count % totalRows;
            if (mod != rowNum) continue;
            ++colNum;
            SelectItem selectItem = (SelectItem)items.get(count);
            writer.startElement("td", selectMany);
            writer.startElement("label", selectMany);
            this.renderGroupOrItemCheckbox(facesContext, selectMany, selectItem, lookupSet != null, lookupSet, converter, false);
            writer.endElement("label");
            writer.endElement("td");
        }
        int totalItems = items.size();
        int totalCols = totalItems / totalRows;
        if (totalItems % totalRows != 0) {
            ++totalCols;
        }
        if (colNum < totalCols) {
            writer.startElement("td", selectMany);
            writer.endElement("td");
        }
        writer.endElement("tr");
    }

    protected void renderCheckboxListVertically(FacesContext facesContext, UISelectMany selectMany, Converter converter) throws IOException {
        boolean useSubmittedValues;
        Set lookupSet = RendererUtils.getSubmittedValuesAsSet(facesContext, selectMany, converter, selectMany);
        boolean bl = useSubmittedValues = lookupSet != null;
        if (!useSubmittedValues) {
            lookupSet = RendererUtils.getSelectedValuesAsSet(facesContext, selectMany, converter, selectMany);
        }
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.startElement("table", selectMany);
        HtmlRendererUtils.renderHTMLAttributes(writer, selectMany, HTML.SELECT_TABLE_PASSTHROUGH_ATTRIBUTES);
        HtmlRendererUtils.writeIdIfNecessary(writer, selectMany, facesContext);
        List items = RendererUtils.getSelectItemList(selectMany);
        int totalItems = items.size();
        for (int count = 0; count < totalItems; ++count) {
            writer.startElement("tr", selectMany);
            int numCols = this.getLayoutWidth(selectMany);
            for (int i = 0; i < numCols; ++i) {
                writer.startElement("td", selectMany);
                if (count < totalItems) {
                    SelectItem selectItem = (SelectItem)items.get(count);
                    writer.startElement("label", selectMany);
                    this.renderGroupOrItemCheckbox(facesContext, selectMany, selectItem, lookupSet != null, lookupSet, converter, true);
                    writer.endElement("label");
                }
                writer.endElement("td");
                if (i >= numCols - 1) continue;
                ++count;
            }
            writer.endElement("tr");
        }
        writer.endElement("table");
    }

    protected String getLayout(UISelectMany selectMany) {
        String layout = super.getLayout(selectMany);
        if (layout == null) {
            layout = LINE_DIRECTION;
        }
        return layout;
    }

    protected int getLayoutWidth(UISelectMany selectMany) {
        String layoutWidthString = null;
        layoutWidthString = selectMany instanceof HtmlSelectManyCheckbox ? ((HtmlSelectManyCheckbox)selectMany).getLayoutWidth() : (String)selectMany.getAttributes().get("layoutWidth");
        boolean defaultLayoutWidth = true;
        int layoutWidth = 1;
        try {
            if (layoutWidthString != null && layoutWidthString.trim().length() > 0) {
                layoutWidth = Integer.parseInt(layoutWidthString);
            }
            if (layoutWidth < 1) {
                layoutWidth = 1;
            }
        }
        catch (Exception e) {
            layoutWidth = 1;
        }
        return layoutWidth;
    }

    private void renderSingleCheckbox(FacesContext facesContext, HtmlCheckbox checkbox) throws IOException {
        Converter converter;
        String forAttr = checkbox.getFor();
        if (forAttr == null) {
            throw new IllegalStateException("mandatory attribute 'for'");
        }
        int index = checkbox.getIndex();
        if (index < 0) {
            throw new IllegalStateException("positive index must be given");
        }
        UIComponent uiComponent = checkbox.findComponent(forAttr);
        if (uiComponent == null) {
            throw new IllegalStateException("Could not find component '" + forAttr + "' (calling findComponent on component '" + checkbox.getClientId(facesContext) + "')");
        }
        if (!(uiComponent instanceof UISelectMany)) {
            throw new IllegalStateException("UISelectMany expected");
        }
        UISelectMany uiSelectMany = (UISelectMany)uiComponent;
        List selectItemList = RendererUtils.getSelectItemList(uiSelectMany);
        if (index >= selectItemList.size()) {
            throw new IndexOutOfBoundsException("index " + index + " >= " + selectItemList.size());
        }
        try {
            converter = RendererUtils.findUISelectManyConverter(facesContext, uiSelectMany);
        }
        catch (FacesException e) {
            converter = null;
        }
        SelectItem selectItem = (SelectItem)selectItemList.get(index);
        Object itemValue = selectItem.getValue();
        String itemStrValue = converter == null ? itemValue.toString() : converter.getAsString(facesContext, uiSelectMany, itemValue);
        Set lookupSet = RendererUtils.getSelectedValuesAsSet(facesContext, uiComponent, converter, uiSelectMany);
        this.renderCheckbox(facesContext, uiSelectMany, itemStrValue, selectItem.getLabel(), this.isDisabled(facesContext, uiSelectMany), lookupSet.contains(itemStrValue), true);
    }

    protected boolean isDisabled(FacesContext facesContext, UIComponent uiComponent) {
        if (!UserRoleUtils.isEnabledOnUserRole(uiComponent)) {
            return true;
        }
        return super.isDisabled(facesContext, uiComponent);
    }

    public void decode(FacesContext facesContext, UIComponent uiComponent) {
        if (!(uiComponent instanceof HtmlCheckbox)) {
            super.decode(facesContext, uiComponent);
        }
    }

    protected Converter getConverter(FacesContext facesContext, UISelectMany selectMany) {
        Converter converter;
        try {
            converter = RendererUtils.findUISelectManyConverter(facesContext, selectMany);
        }
        catch (FacesException e) {
            log.error((Object)("Error finding Converter for component with id " + selectMany.getClientId(facesContext)));
            converter = null;
        }
        return converter;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

