/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.aop.javassist;

public class TryBlockSupport {
    protected static final int STATUS_TRY = 0;
    protected static final int STATUS_CATCH = 1;
    protected static final int STATUS_FINALLY = 2;
    protected int status;
    protected StringBuffer codeBuf = new StringBuffer(500);
    static /* synthetic */ Class class$0;

    public TryBlockSupport(String src) {
        this.codeBuf.append("try {").append(src).append("}");
        this.status = 0;
    }

    public void addCatchBlock(Class exceptionType, String src) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.Throwable");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (!clazz.isAssignableFrom(exceptionType)) {
            throw new IllegalArgumentException("exceptionType must be Throwable.");
        }
        if (this.status != 0 && this.status != 1) {
            throw new IllegalStateException("could't append catch block after finally block.");
        }
        this.codeBuf.append("catch (").append(exceptionType.getName()).append(" e) {").append(src).append("}");
        this.status = 1;
    }

    public void setFinallyBlock(String src) {
        if (this.status != 0 && this.status != 1) {
            throw new IllegalStateException("finally block is already appended.");
        }
        this.codeBuf.append("finally {").append(src).append("}");
        this.status = 2;
    }

    public String getSourceCode() {
        if (this.status != 1 && this.status != 2) {
            throw new IllegalStateException("must set catch block or finally block.");
        }
        return new String(this.codeBuf);
    }
}

