/*
 * Decompiled with CFR 0.152.
 */
package net.sf.swarmcache;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import net.sf.swarmcache.CacheConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CacheConfigurationManager {
    private static final Log LOG = LogFactory.getLog((Class)(class$net$sf$swarmcache$CacheConfigurationManager == null ? (class$net$sf$swarmcache$CacheConfigurationManager = CacheConfigurationManager.class$("net.sf.swarmcache.CacheConfigurationManager")) : class$net$sf$swarmcache$CacheConfigurationManager));
    public static final String SWARMCACHE_PROP_FILE_NAME = "swarmcache.properties";
    public static final String SWARMCACHE_CHANNEL_PROPS = "swarmcache.channel.properties";
    public static final String SWARMCACHE_MULTICAST_IP = "swarmcache.multicast.ip";
    public static final String SWARMCACHE_CACHE_TYPE = "swarmcache.cache.type";
    public static final String SWARMCACHE_LRU_SIZE = "swarmcache.lru.size";
    static Properties defaults = CacheConfigurationManager.initializeDefaults();
    static /* synthetic */ Class class$net$sf$swarmcache$CacheConfigurationManager;

    private CacheConfigurationManager() {
    }

    static Properties initializeDefaults() {
        LOG.debug((Object)"Initializing cache configuration defaults.");
        Properties defaults = new Properties();
        defaults.put(SWARMCACHE_MULTICAST_IP, "231.12.21.132");
        defaults.put(SWARMCACHE_CACHE_TYPE, "LRU");
        defaults.put(SWARMCACHE_LRU_SIZE, "10000");
        InputStream is = (class$net$sf$swarmcache$CacheConfigurationManager == null ? (class$net$sf$swarmcache$CacheConfigurationManager = CacheConfigurationManager.class$("net.sf.swarmcache.CacheConfigurationManager")) : class$net$sf$swarmcache$CacheConfigurationManager).getClassLoader().getResourceAsStream(SWARMCACHE_PROP_FILE_NAME);
        if (is != null) {
            LOG.debug((Object)"Reading cache configuration from 'swarmcache.properties'...");
            Properties props = new Properties(defaults);
            try {
                props.load(is);
            }
            catch (IOException e) {
                String s = "Unable to load 'swarmcache.properties' due to IOException.";
                LOG.error((Object)"Unable to load 'swarmcache.properties' due to IOException.", (Throwable)e);
                throw new IllegalStateException("Unable to load 'swarmcache.properties' due to IOException.");
            }
            defaults = props;
        } else {
            LOG.info((Object)"Unable to load 'swarmcache.properties'... Using defaults.");
        }
        LOG.debug((Object)("Using default values: " + defaults));
        return defaults;
    }

    static CacheConfiguration buildConfigurationInternal(Properties props) {
        String lruSize;
        CacheConfiguration myConfig = new CacheConfiguration();
        String channelProps = props.getProperty(SWARMCACHE_CHANNEL_PROPS);
        String multicastIp = props.getProperty(SWARMCACHE_MULTICAST_IP);
        if (channelProps != null) {
            LOG.debug((Object)("Setting channel properties to " + channelProps));
            myConfig.setChannelProperties(channelProps);
        } else if (multicastIp != null) {
            LOG.debug((Object)("Setting multicast IP to " + multicastIp));
            myConfig.setMulticastIP(multicastIp);
        } else {
            throw new IllegalArgumentException("Either the channel properties or the multicast IP address must be specified.");
        }
        String cacheType = props.getProperty(SWARMCACHE_CACHE_TYPE);
        if (cacheType != null) {
            LOG.debug((Object)("Setting cache type to " + cacheType));
            myConfig.setCacheType(cacheType);
        }
        if ((lruSize = props.getProperty(SWARMCACHE_LRU_SIZE)) != null) {
            LOG.debug((Object)("Setting LRU size to " + lruSize));
            myConfig.setLRUCacheSize(lruSize);
        }
        return myConfig;
    }

    public static CacheConfiguration getConfig() {
        return CacheConfigurationManager.buildConfigurationInternal(defaults);
    }

    public static CacheConfiguration getConfig(Properties props) {
        Properties defaultedProps = new Properties(defaults);
        defaultedProps.putAll((Map<?, ?>)props);
        return CacheConfigurationManager.buildConfigurationInternal(defaultedProps);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

