<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://java.sun.com/jsf/html" prefix="h" %>
<%@ taglib uri="http://java.sun.com/jsf/core" prefix="f" %>
<%@ taglib uri="http://myfaces.apache.org/tomahawk" prefix="t"%>
<f:view>
    <f:loadBundle basename="jp.sf.pal.blog.resources.BlogEditResources" var="msgs"/>
    <h:form>
        <h:outputText value="#{editPortlet.msgSuccess}" styleClass="portlet-msg-success" escape="false" rendered="#{editPortlet.isMsgSuccess}"/>
        <h:outputText value="#{editPortlet.msgError}" styleClass="portlet-msg-error" escape="false" rendered="#{editPortlet.isMsgError}"/>
        <h:outputText value="#{editPortlet.msgAlert}" styleClass="portlet-msg-alert" escape="false" rendered="#{editPortlet.isMsgAlert}"/>
        <h:outputText value="#{editPortlet.msgInfo}" styleClass="portlet-msg-info" escape="false" rendered="#{editPortlet.isMsgInfo}"/>
        
        <h:panelGrid columns="2" border="0">
            <!-- Title -->
            <h:outputLabel for="title">
                <h:outputText value="#{msgs['blogedit.Title']}" styleClass="portlet-form-field"/>
            </h:outputLabel>
            <h:inputText id="title" value="#{editPage.title}" size="50" styleClass="portlet-form-field-label"/>
            <!-- Created Date -->
            <h:outputLabel for="createddate" rendered="#{editPage.id!=null}">
                <h:outputText value="#{msgs['blogedit.CreatedDate']}" styleClass="portlet-form-field"/>
            </h:outputLabel>
            <h:outputText id="creaeddate" value="#{editPage.formattedCreatedTime}" styleClass="portlet-form-label" rendered="#{editPage.id!=null}"/>
            <!-- Updated Date -->
            <h:outputLabel for="updateddate" rendered="#{editPage.id!=null}">
                <h:outputText value="#{msgs['blogedit.UpdatedDate']}" styleClass="portlet-form-field"/>
            </h:outputLabel>
            <h:outputText id="updateddate" value="#{editPage.formattedUpdatedTime}" styleClass="portlet-form-label" rendered="#{editPage.id!=null}"/>
        </h:panelGrid>
        <!-- Contents -->
        <h:inputTextarea value="#{editPage.message}" cols="80" rows="30"/>
        <br/>
        <!-- Save -->
        <h:panelGrid columns="1" border="0" rendered="#{editPage.id==null}">
            <h:commandButton action="#{editPage.save}" value="#{msgs['blogedit.Save']}" styleClass="portlet-form-button"/>
        </h:panelGrid>
        <!-- Update -->
        <h:panelGrid columns="2" border="0" rendered="#{editPage.id!=null}">
            <h:commandButton action="#{editPage.save}" value="#{msgs['blogedit.Update']}" styleClass="portlet-form-button"/>
            <h:commandButton action="#{editPage.reset}" value="#{msgs['blogedit.Reset']}" styleClass="portlet-form-button"/>
        </h:panelGrid>
        <h:inputHidden value="#{editPage.id}" />
        <!-- Delete -->
        <h:panelGrid columns="1" border="0" rendered="#{editPage.id!=null}">
            <h:commandButton action="#{editPage.delete}" value="#{msgs['blogedit.Delete']}" styleClass="portlet-form-button"/>
        </h:panelGrid>
    </h:form>
</f:view>
