/*
 * Copyright 2004 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.pal.myfaces.portlet.selector;

import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;

/**
 * Imlementations of this interface allow a JSF application to specify which
 * JSF view will be selected when the incoming request does not provide a View
 * Id.  The implementation can optionally return <code>null</code> to revert to
 * the default View Id specified in portlet.xml.
 *
 * @author  Stan Silvert (latest modification by $Author: shinsuke $)
 * @version $Revision: 1.1.1.1 $ $Date: 2005/11/10 23:38:32 $
 * $Log: DefaultViewSelector.java,v $
 * Revision 1.1.1.1  2005/11/10 23:38:32  shinsuke
 * create bridges-myfaces repo
 *
 * Revision 1.3  2005/08/11 22:40:46  shinsuke
 * added javadoc. added AbstractHeaderResource
 *
 * Revision 1.2  2005/08/09 22:23:45  shinsuke
 * refactored myfaces bridges
 *
 * Revision 1.1  2005/08/06 22:34:46  shinsuke
 * added myfaces bridges, vfs-portlet, cms-portlet
 *
 * Revision 1.1  2005/01/26 17:03:10  matzew
 * MYFACES-86. portlet support provided by Stan Silver (JBoss Group)
 *
 */
public interface DefaultViewSelector {
    
    /**
     * This method will be called by the MyFacesGenericPortlet in order to 
     * give the selector an opportunity to store a reference to the 
     * PortletContext.
     */
    public void setPortletContext(PortletContext portletContext);

    /**
     * This method will be called by the MyFacesGenericPortlet in order to 
     * give the selector an opportunity to retrieve information from  
     * PortletConfing.
     */
    public void setPortletConfig(PortletConfig portletConfig);
    
    /**
     * This method allows a JSF application to specify which JSF view will be
     * when the incoming request does not provide a view id.
     *
     * @param request The RenderRequest
     * @param response The RenderResponse
     * @return a JSF View Id, or <code>null</code> if the selector wishes to
     *         revert to the default View Id specified in portlet.xml.
     * @throws PortletException if a View Id can not be determined because of
     *                          some underlying error.
     */
    public String selectViewId(RenderRequest request, RenderResponse response) throws PortletException;
}
