/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.aop.intertype;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.seasar.framework.aop.intertype.AbstractInterType;
import org.seasar.framework.log.Logger;
import org.seasar.framework.util.ClassUtil;
import org.seasar.framework.util.StringUtil;

public class PropertyInterType
extends AbstractInterType {
    private static final String SETTER_PREFIX = "set";
    private static final String GETTER_PREFIX = "get";
    protected static final int NONE = 0;
    protected static final int READ = 1;
    protected static final int WRITE = 2;
    protected static final int READWRITE = 3;
    protected static final String STR_NONE = "none";
    protected static final String STR_READ = "read";
    protected static final String STR_WRITE = "write";
    protected static final String STR_READWRITE = "readwrite";
    private static final String TIGER_ANNOTATION_HANDLER = "org.seasar.framework.aop.intertype.TigerPropertyAnnotationHandler";
    private static final String BACKPORT175_ANNOTATION_HANDLER = "org.seasar.framework.aop.intertype.Backport175PropertyAnnotationHandler";
    private static Logger logger = Logger.getLogger(class$org$seasar$framework$aop$intertype$PropertyInterType == null ? (class$org$seasar$framework$aop$intertype$PropertyInterType = PropertyInterType.class$("org.seasar.framework.aop.intertype.PropertyInterType")) : class$org$seasar$framework$aop$intertype$PropertyInterType);
    private static PropertyAnnotationHandler annotationHandler = new DefaultPropertyAnnotationHandler();
    private boolean trace;
    private int defaultPropertyType = 3;
    static /* synthetic */ Class class$org$seasar$framework$aop$intertype$PropertyInterType;

    protected static int valueOf(String type) {
        int propertyType = 0;
        if (STR_READ.equals(type)) {
            propertyType = 1;
        } else if (STR_WRITE.equals(type)) {
            propertyType = 2;
        } else if (STR_READWRITE.equals(type)) {
            propertyType = 3;
        }
        return propertyType;
    }

    private static void setupAnnotationHandler() {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(TIGER_ANNOTATION_HANDLER, true, (class$org$seasar$framework$aop$intertype$PropertyInterType == null ? (class$org$seasar$framework$aop$intertype$PropertyInterType = PropertyInterType.class$("org.seasar.framework.aop.intertype.PropertyInterType")) : class$org$seasar$framework$aop$intertype$PropertyInterType).getClassLoader());
        }
        catch (ClassNotFoundException e) {
            try {
                clazz = Class.forName(BACKPORT175_ANNOTATION_HANDLER, true, (class$org$seasar$framework$aop$intertype$PropertyInterType == null ? (class$org$seasar$framework$aop$intertype$PropertyInterType = PropertyInterType.class$("org.seasar.framework.aop.intertype.PropertyInterType")) : class$org$seasar$framework$aop$intertype$PropertyInterType).getClassLoader());
            }
            catch (ClassNotFoundException e2) {
                return;
            }
        }
        annotationHandler = (PropertyAnnotationHandler)ClassUtil.newInstance(clazz);
    }

    public void setTrace(boolean trace) {
        this.trace = trace;
    }

    public void setDefaultPropertyType(String defaultPropertyType) {
        this.defaultPropertyType = PropertyInterType.valueOf(defaultPropertyType);
    }

    protected void introduce() {
        if (logger.isDebugEnabled()) {
            logger.debug("[PropertyInterType] Introducing... " + this.targetClass.getName());
        }
        int defaultValue = annotationHandler.getPropertyType(this.getTargetClass(), this.defaultPropertyType);
        List targetFields = this.getTargetFields(this.targetClass);
        Iterator iter = targetFields.iterator();
        while (iter.hasNext()) {
            Field field = (Field)iter.next();
            int property = annotationHandler.getPropertyType(field, defaultValue);
            switch (property) {
                case 1: {
                    this.createGetter(this.targetClass, field);
                    break;
                }
                case 2: {
                    this.createSetter(this.targetClass, field);
                    break;
                }
                case 3: {
                    this.createGetter(this.targetClass, field);
                    this.createSetter(this.targetClass, field);
                    break;
                }
            }
        }
    }

    private void createGetter(Class targetClass, Field targetField) {
        String targetFieldName = targetField.getName();
        String methodName = GETTER_PREFIX + this.createMethodName(targetFieldName);
        if (this.hasMethod(methodName, null)) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("[PropertyInterType] Creating getter " + targetClass.getName() + "#" + methodName);
        }
        StringBuffer src = new StringBuffer(512);
        src.append("{");
        if (this.trace) {
            src.append("org.seasar.framework.log.Logger logger =");
            src.append("org.seasar.framework.log.Logger.getLogger($class);");
            src.append("if(logger.isDebugEnabled()){");
            src.append("logger.debug(\"CALL \" + $class.getSuperclass().getName() + \"#");
            src.append(methodName);
            src.append("() : \" + this.");
            src.append(targetFieldName);
            src.append(");}");
        }
        src.append("return this.");
        src.append(targetFieldName);
        src.append(";}");
        this.addMethod(targetField.getType(), methodName, src.toString());
    }

    private void createSetter(Class targetClass, Field targetField) {
        String targetFieldName = targetField.getName();
        String methodName = SETTER_PREFIX + this.createMethodName(targetFieldName);
        if (this.hasMethod(methodName, targetField.getType())) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("[PropertyInterType] Creating setter " + targetClass.getName() + "#" + methodName);
        }
        StringBuffer src = new StringBuffer(512);
        src.append("{");
        if (this.trace) {
            src.append("org.seasar.framework.log.Logger logger =");
            src.append("org.seasar.framework.log.Logger.getLogger($class);");
            src.append("if(logger.isDebugEnabled()){");
            src.append("logger.debug(\"CALL \" + $class.getSuperclass().getName() + \"#");
            src.append(methodName);
            src.append("(\" + $1 + \")\");}");
        }
        src.append("this.");
        src.append(targetFieldName);
        src.append(" = $1;}");
        this.addMethod(methodName, new Class[]{targetField.getType()}, src.toString());
    }

    private List getTargetFields(Class targetClass) {
        ArrayList<Field> targetFields = new ArrayList<Field>();
        Field[] nominationFields = this.getFields(targetClass);
        for (int i = 0; i < nominationFields.length; ++i) {
            Field field = nominationFields[i];
            int modifier = field.getModifiers();
            if (Modifier.isPrivate(modifier)) continue;
            targetFields.add(field);
        }
        return targetFields;
    }

    private Field[] getFields(Class targetClass) {
        Class superClass = targetClass.getSuperclass();
        Field[] superFields = new Field[]{};
        if (superClass != null) {
            superFields = this.getFields(superClass);
        }
        Field[] currentFields = targetClass.getDeclaredFields();
        Field[] fields = new Field[superFields.length + currentFields.length];
        System.arraycopy(superFields, 0, fields, 0, superFields.length);
        System.arraycopy(currentFields, 0, fields, superFields.length, currentFields.length);
        return fields;
    }

    private String createMethodName(String fieldName) {
        String methodName = StringUtil.capitalize(fieldName);
        if (methodName.endsWith("_")) {
            methodName = methodName.substring(0, methodName.length() - 1);
        }
        return methodName;
    }

    private boolean hasMethod(String methodName, Class paramType) {
        Class[] param = null;
        if (paramType != null) {
            param = new Class[]{paramType};
        }
        try {
            this.getTargetClass().getMethod(methodName, param);
            return true;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        PropertyInterType.setupAnnotationHandler();
    }

    public static class DefaultPropertyAnnotationHandler
    implements PropertyAnnotationHandler {
        public int getPropertyType(Class clazz, int defaultValue) {
            return defaultValue;
        }

        public int getPropertyType(Field field, int defaultValue) {
            return defaultValue;
        }
    }

    public static interface PropertyAnnotationHandler {
        public int getPropertyType(Class var1, int var2);

        public int getPropertyType(Field var1, int var2);
    }
}

