/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.internal;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.el.EvaluationException;
import javax.faces.el.MethodBinding;
import javax.faces.internal.IgnoreComponent;
import javax.faces.internal.ModifierUtil;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.PropertyDesc;
import org.seasar.framework.beans.factory.BeanDescFactory;
import org.seasar.framework.util.ArrayUtil;

public class UIComponentUtil {
    private static final IgnoreComponent DEFAULT_IGNORE = new IgnoreComponent();

    private UIComponentUtil() {
    }

    public static boolean isDisabled(UIComponent component) {
        return UIComponentUtil.getPrimitiveBooleanAttribute(component, "disabled");
    }

    public static String getStringAttribute(UIComponent component, String name) {
        return (String)component.getAttributes().get(name);
    }

    public static boolean getPrimitiveBooleanAttribute(UIComponent component, String name) {
        Object value = component.getAttributes().get(name);
        if (value == null) {
            return false;
        }
        return (Boolean)value;
    }

    public static int getPrimitiveIntAttribute(UIComponent component, String name) {
        Object value = component.getAttributes().get(name);
        if (value == null) {
            return 0;
        }
        return (Integer)value;
    }

    public static String getLabel(UIComponent component) {
        String label = (String)component.getAttributes().get("label");
        if (label != null) {
            return label;
        }
        return component.getId();
    }

    public static void callValidators(FacesContext context, UIInput input, Object convertedValue) {
        FacesMessage facesMessage;
        Validator[] validators = input.getValidators();
        for (int i = 0; i < validators.length; ++i) {
            Validator validator = validators[i];
            try {
                validator.validate(context, input, convertedValue);
                continue;
            }
            catch (ValidatorException e) {
                input.setValid(false);
                facesMessage = e.getFacesMessage();
                if (facesMessage == null) continue;
                context.addMessage(input.getClientId(context), facesMessage);
            }
        }
        MethodBinding validatorBinding = input.getValidator();
        if (validatorBinding != null) {
            try {
                validatorBinding.invoke(context, new Object[]{context, input, convertedValue});
            }
            catch (EvaluationException e) {
                input.setValid(false);
                Throwable cause = e.getCause();
                if (cause instanceof ValidatorException) {
                    facesMessage = ((ValidatorException)cause).getFacesMessage();
                    if (facesMessage != null) {
                        context.addMessage(input.getClientId(context), facesMessage);
                    }
                }
                throw e;
            }
        }
    }

    public static Map getAllAttributesAndProperties(UIComponent component) {
        return UIComponentUtil.getAllAttributesAndProperties(component, DEFAULT_IGNORE);
    }

    public static Map getAllAttributesAndProperties(UIComponent component, IgnoreComponent ignore) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        BeanDesc beanDesc = BeanDescFactory.getBeanDesc(component.getClass());
        for (int i = 0; i < beanDesc.getPropertyDescSize(); ++i) {
            PropertyDesc propertyDesc = beanDesc.getPropertyDesc(i);
            Method m = propertyDesc.getReadMethod();
            if (!propertyDesc.hasReadMethod() || !UIComponentUtil.isPublicNoParameterMethod(m) || ArrayUtil.contains((Object[])ignore.getIgnoreComponentNames(), (Object)propertyDesc.getPropertyName())) continue;
            map.put(propertyDesc.getPropertyName(), propertyDesc.getValue((Object)component));
        }
        map.putAll(component.getAttributes());
        return map;
    }

    private static boolean isPublicNoParameterMethod(Method m) {
        return ModifierUtil.isPublic(m) && m.getParameterTypes().length == 0;
    }
}

