/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.webapp;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.internal.PageContextUtil;
import javax.faces.internal.ValueBindingUtil;
import javax.faces.internal.WebAppUtil;
import javax.faces.webapp.FacetTag;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.Tag;
import org.seasar.framework.util.AssertionUtil;

public abstract class UIComponentTag
implements Tag {
    private UIComponent component = null;
    private FacesContext context = null;
    private boolean created = false;
    private List createdComponents = null;
    private List createdFacets = null;
    protected PageContext pageContext = null;
    private Tag parent = null;
    private String binding = null;
    private String id = null;
    private String rendered = null;

    public void setBinding(String binding) throws JspException {
        if (!UIComponentTag.isValueReference(binding)) {
            throw new IllegalArgumentException();
        }
        this.binding = binding;
    }

    public void setId(String id) {
        if (null != id && id.startsWith("_id")) {
            throw new IllegalArgumentException();
        }
        this.id = id;
    }

    public void setRendered(String rendered) {
        this.rendered = rendered;
    }

    public abstract String getComponentType();

    public UIComponent getComponentInstance() {
        return this.component;
    }

    public boolean getCreated() {
        return this.created;
    }

    public static UIComponentTag getParentUIComponentTag(PageContext context) {
        List list = PageContextUtil.getComponentTagStackAttribute(context);
        if (list != null) {
            return (UIComponentTag)list.get(list.size() - 1);
        }
        return null;
    }

    public abstract String getRendererType();

    public static boolean isValueReference(String value) {
        AssertionUtil.assertNotNull((String)"value", (Object)value);
        return value.indexOf("#{") != -1 && value.indexOf("#{") < value.indexOf(125);
    }

    public void setPageContext(PageContext pageContext) {
        this.pageContext = pageContext;
    }

    public Tag getParent() {
        return this.parent;
    }

    public void setParent(Tag parent) {
        this.parent = parent;
    }

    public int doStartTag() throws JspException {
        this.context = PageContextUtil.getCurrentFacesContextAttribute(this.pageContext);
        if (this.context == null) {
            this.context = FacesContext.getCurrentInstance();
            if (this.context == null) {
                throw new JspException("Cannot find FacesContext");
            }
            PageContextUtil.setCurrentFacesContextAttribute(this.pageContext, this.context);
        }
        this.setupResponseWriter();
        UIComponentTag parentTag = UIComponentTag.getParentUIComponentTag(this.pageContext);
        Map requestMap = this.context.getExternalContext().getRequestMap();
        Map<String, UIComponentTag> componentIds = null;
        if (parentTag == null) {
            componentIds = new HashMap();
            requestMap.put("javax.faces.webapp.GLOBAL_ID_VIEW", componentIds);
        } else {
            componentIds = (Map)requestMap.get("javax.faces.webapp.GLOBAL_ID_VIEW");
        }
        this.component = this.findComponent(this.context);
        boolean isAlreadyTagInstanced = false;
        String clientId = null;
        if (this.id != null) {
            clientId = this.component.getClientId(this.context);
            boolean bl = isAlreadyTagInstanced = componentIds.get(clientId) == this;
            if (!isAlreadyTagInstanced && clientId != null) {
                if (!componentIds.containsKey(clientId)) {
                    componentIds.put(clientId, this);
                } else {
                    throw new JspException((Throwable)new IllegalStateException("Duplicate component id: '" + clientId + "', first used in tag: '" + componentIds.get(clientId).getClass().getName() + "'"));
                }
            }
        }
        if (!isAlreadyTagInstanced && parentTag != null) {
            if (this.getFacetName() == null) {
                parentTag.addChild(this.component);
            } else {
                parentTag.addFacet(this.getFacetName());
            }
        }
        try {
            if (!this.isSuppressed() && !this.component.getRendersChildren()) {
                this.encodeBegin();
                this.context.getResponseWriter().flush();
            }
        }
        catch (IOException e) {
            this.component = null;
            this.context = null;
            throw new JspException((Throwable)e);
        }
        this.pushUIComponentTag();
        return this.getDoStartValue();
    }

    public int doEndTag() throws JspException {
        this.popUIComponentTag();
        this.removeOldChildren();
        this.removeOldFacets();
        try {
            if (!this.isSuppressed()) {
                if (this.component.getRendersChildren()) {
                    this.encodeBegin();
                    this.encodeChildren();
                }
                this.encodeEnd();
            }
        }
        catch (IOException e) {
            throw new JspException((Throwable)e);
        }
        finally {
            this.component = null;
            this.context = null;
        }
        this.created = false;
        return this.getDoEndValue();
    }

    public void release() {
        this.parent = null;
        this.binding = null;
        this.id = null;
        this.created = false;
        this.rendered = null;
    }

    protected void encodeBegin() throws IOException {
        this.component.encodeBegin(this.context);
    }

    protected void encodeChildren() throws IOException {
        this.component.encodeChildren(this.context);
    }

    protected void encodeEnd() throws IOException {
        this.component.encodeEnd(this.context);
    }

    protected UIComponent findComponent(FacesContext context) throws JspException {
        if (this.component != null) {
            return this.component;
        }
        UIComponentTag parentTag = UIComponentTag.getParentUIComponentTag(this.pageContext);
        UIComponent parentComponent = null;
        if (parentTag != null) {
            parentComponent = parentTag.getComponentInstance();
            String newId = this.createNewId();
            String facetName = this.getFacetName();
            if (facetName != null) {
                this.component = (UIComponent)parentComponent.getFacets().get(facetName);
                if (this.component == null) {
                    this.component = this.createFacet(context, parentComponent, facetName, newId);
                }
            } else {
                this.component = this.getChild(parentComponent, newId);
                if (this.component == null) {
                    this.component = this.createChild(context, parentComponent, newId);
                }
            }
            return this.component;
        }
        this.component = this.findComponentSpecially(context);
        return this.component;
    }

    private UIComponent findComponentSpecially(FacesContext context) {
        UIComponent parentComponent = PageContextUtil.getCurrentViewRootAttribute(this.pageContext);
        if (parentComponent == null) {
            parentComponent = context.getViewRoot();
            PageContextUtil.setCurrentViewRootAttribute(this.pageContext, parentComponent);
            if (parentComponent.getAttributes().get("javax.faces.webapp.CURRENT_VIEW_ROOT") == null) {
                this.setProperties(parentComponent);
                if (this.id != null) {
                    parentComponent.setId(this.id);
                }
                parentComponent.getAttributes().put("javax.faces.webapp.CURRENT_VIEW_ROOT", "javax.faces.webapp.CURRENT_VIEW_ROOT");
            } else if (this.binding == null) {
                this.setProperties(parentComponent);
            }
        }
        return parentComponent;
    }

    protected int getDoEndValue() throws JspException {
        return 6;
    }

    protected int getDoStartValue() throws JspException {
        return 1;
    }

    protected FacesContext getFacesContext() {
        return this.context;
    }

    protected String getFacetName() {
        Tag parent = this.getParent();
        if (parent instanceof FacetTag) {
            return ((FacetTag)parent).getName();
        }
        return null;
    }

    protected String getId() {
        return this.id;
    }

    protected boolean isSuppressed() {
        if (this.getFacetName() != null) {
            return true;
        }
        if (!this.component.isRendered()) {
            return true;
        }
        for (UIComponent c = this.component.getParent(); c != null; c = c.getParent()) {
            if (c.isRendered() && !c.getRendersChildren()) continue;
            return true;
        }
        return false;
    }

    protected void setProperties(UIComponent component) {
        if (this.rendered != null) {
            if (UIComponentTag.isValueReference(this.rendered)) {
                component.setValueBinding("rendered", ValueBindingUtil.createValueBinding(this.context, this.rendered));
            } else {
                component.setRendered(Boolean.valueOf(this.rendered));
            }
        }
        if (this.getRendererType() != null) {
            component.setRendererType(this.getRendererType());
        }
    }

    protected void setupResponseWriter() {
        ResponseWriter writer = this.context.getResponseWriter();
        if (writer == null) {
            writer = WebAppUtil.buildResponseWriter(this.context, this.pageContext);
            this.context.setResponseWriter(writer);
        }
    }

    private void addChild(UIComponent child) {
        if (this.createdComponents == null) {
            this.createdComponents = new ArrayList();
        }
        this.createdComponents.add(child.getId());
    }

    private void addFacet(String name) {
        if (this.createdFacets == null) {
            this.createdFacets = new ArrayList();
        }
        this.createdFacets.add(name);
    }

    private UIComponent createComponent(FacesContext context, String newId) {
        UIComponent component = WebAppUtil.createComponent(context, this.binding, this.getComponentType());
        component.setId(newId);
        this.setProperties(component);
        return component;
    }

    private UIComponent createChild(FacesContext context, UIComponent parent, String componentId) {
        UIComponent component = this.createComponent(context, componentId);
        UIComponentTag parentTag = UIComponentTag.getParentUIComponentTag(this.pageContext);
        parent.getChildren().add(parentTag.getIndex(), component);
        this.created = true;
        return component;
    }

    private UIComponent createFacet(FacesContext context, UIComponent parent, String name, String newId) {
        UIComponent component = this.createComponent(context, newId);
        parent.getFacets().put(name, component);
        this.created = true;
        return component;
    }

    private UIComponent getChild(UIComponent component, String componentId) {
        Iterator children = component.getChildren().iterator();
        while (children.hasNext()) {
            UIComponent child = (UIComponent)children.next();
            if (!componentId.equals(child.getId())) continue;
            return child;
        }
        return null;
    }

    private int getIndex() {
        return this.createdComponents != null ? this.createdComponents.size() : 0;
    }

    private void popUIComponentTag() {
        List list = PageContextUtil.getComponentTagStackAttribute(this.pageContext);
        if (list != null) {
            list.remove(list.size() - 1);
            if (list.size() < 1) {
                PageContextUtil.removeComponentStackAttribute(this.pageContext);
            }
        }
    }

    private void pushUIComponentTag() {
        ArrayList<UIComponentTag> list = PageContextUtil.getComponentTagStackAttribute(this.pageContext);
        if (list == null) {
            list = new ArrayList<UIComponentTag>();
            PageContextUtil.setComponentStackAttribute(this.pageContext, list);
        }
        list.add(this);
    }

    private void removeOldChildren() {
        List oldList = WebAppUtil.getCreatedComponentIds(this.component);
        if (oldList == null) {
            this.saveChildrenComponentAttribute();
            return;
        }
        Iterator olds = oldList.iterator();
        while (olds.hasNext()) {
            UIComponent child;
            String old = (String)olds.next();
            if (this.createdComponents != null && this.createdComponents.contains(old) || (child = this.component.findComponent(old)) == null) continue;
            this.component.getChildren().remove(child);
        }
        this.saveChildrenComponentAttribute();
    }

    private void removeOldFacets() {
        List oldList = WebAppUtil.getCreatedFacetNames(this.component);
        if (oldList == null) {
            this.saveFacetsComponentAttribute();
            return;
        }
        Iterator olds = oldList.iterator();
        while (olds.hasNext()) {
            String old = (String)olds.next();
            if (this.createdFacets != null && this.createdFacets.contains(old)) continue;
            this.component.getFacets().remove(old);
        }
        this.saveFacetsComponentAttribute();
    }

    private void saveChildrenComponentAttribute() {
        if (this.createdComponents != null) {
            WebAppUtil.setCreatedComponentIds(this.component, this.createdComponents);
        } else {
            WebAppUtil.removeCreatedComponentIds(this.component);
        }
        this.createdComponents = null;
    }

    private void saveFacetsComponentAttribute() {
        if (this.createdFacets != null) {
            WebAppUtil.setCreatedFacetNames(this.component, this.createdFacets);
        } else {
            WebAppUtil.removeCreatedFacetNames(this.component);
        }
        this.createdFacets = null;
    }

    private String createNewId() {
        if (this.id == null) {
            FacesContext context = PageContextUtil.getCurrentFacesContextAttribute(this.pageContext);
            return context.getViewRoot().createUniqueId();
        }
        return this.id;
    }
}

