/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.application;

import java.io.IOException;
import javax.faces.component.ActionSource;
import javax.faces.component.UICommand;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.el.EvaluationException;
import javax.faces.el.MethodBinding;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.event.ActionListener;
import org.seasar.framework.log.Logger;
import org.seasar.teeda.core.util.ErrorPageManager;
import org.seasar.teeda.core.util.InvokeUtil;
import org.seasar.teeda.core.util.NavigationHandlerUtil;
import org.seasar.teeda.core.util.NullErrorPageManagerImpl;
import org.seasar.teeda.core.util.UIParameterUtil;

public class ActionListenerImpl
implements ActionListener {
    private static Logger logger = Logger.getLogger((Class)ActionListenerImpl.class);
    private ErrorPageManager errorPageManager_ = new NullErrorPageManagerImpl();

    public void processAction(ActionEvent actionEvent) throws AbortProcessingException {
        FacesContext context = FacesContext.getCurrentInstance();
        if (actionEvent.getComponent() instanceof UICommand) {
            UICommand command = (UICommand)actionEvent.getComponent();
            UIParameterUtil.saveParametersToRequest(command, context);
        }
        ActionSource actionSource = (ActionSource)((Object)actionEvent.getComponent());
        MethodBinding mb = actionSource.getAction();
        String fromAction = null;
        String outcome = null;
        if (mb != null) {
            fromAction = mb.getExpressionString();
            try {
                outcome = InvokeUtil.invoke(mb, context);
            }
            catch (EvaluationException ex) {
                Throwable cause = ex.getCause();
                ErrorPageManager manager = this.getErrorPageManager();
                try {
                    ExternalContext extContext = context.getExternalContext();
                    if (!manager.handleException(cause, extContext)) {
                        throw ex;
                    }
                    context.responseComplete();
                }
                catch (IOException ioe) {
                    logger.log((Throwable)ioe);
                    throw ex;
                }
            }
        }
        NavigationHandlerUtil.handleNavigation(context, fromAction, outcome);
        context.renderResponse();
    }

    public ErrorPageManager getErrorPageManager() {
        return this.errorPageManager_;
    }

    public void setErrorPageManager(ErrorPageManager errorPageManager) {
        this.errorPageManager_ = errorPageManager;
    }
}

