/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.config.faces.handler;

import java.lang.reflect.Method;
import org.seasar.framework.log.Logger;
import org.seasar.framework.xml.TagHandlerContext;
import org.seasar.teeda.core.config.faces.handler.JsfTagHandler;
import org.seasar.teeda.core.util.TagConvertUtil;

public class SimpleStringTagHandler
extends JsfTagHandler {
    private static Logger logger = Logger.getLogger((Class)SimpleStringTagHandler.class);
    private static final long serialVersionUID = 3257284721212863026L;
    private static final int SINGLE_PARAMETER = 1;
    private String tagName;

    public SimpleStringTagHandler(String tagName) {
        this.tagName = tagName;
    }

    public void end(TagHandlerContext context, String body) {
        this.setAppropriateProperty(context.peek(), body);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setAppropriateProperty(Object tag, String context) {
        if (context == null) {
            return;
        }
        String[] setters = TagConvertUtil.convertToSetter(this.tagName);
        Method[] methods = tag.getClass().getDeclaredMethods();
        String setterName = null;
        Method method = null;
        block5: for (int i = 0; i < setters.length; ++i) {
            setterName = setters[i];
            for (int j = 0; j < methods.length; ++j) {
                method = methods[j];
                boolean isSameSetter = SimpleStringTagHandler.isSameSetter(method, setterName);
                boolean isSingleParameter = SimpleStringTagHandler.isSingleParameter(method);
                if (!isSameSetter || !isSingleParameter) continue;
                try {
                    method.invoke(tag, context);
                    continue;
                }
                catch (Exception ignore) {
                    logger.log((Throwable)ignore);
                    continue block5;
                }
                finally {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("<" + this.tagName + ">" + context + "</" + this.tagName + ">"));
                    }
                }
            }
        }
    }

    private static boolean isSameSetter(Method method, String setterName) {
        return setterName.equals(method.getName());
    }

    private static boolean isSingleParameter(Method method) {
        return method.getParameterTypes().length == 1;
    }
}

