/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.interceptor;

import java.io.PrintWriter;
import java.util.Iterator;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.component.html.HtmlCommandLink;
import javax.faces.component.html.HtmlOutputText;
import javax.faces.context.FacesContext;
import org.aopalliance.intercept.MethodInvocation;
import org.seasar.framework.aop.interceptors.AbstractInterceptor;
import org.seasar.framework.log.Logger;
import org.seasar.framework.util.SPrintWriter;

public class DumpComponentTreeInterceptor
extends AbstractInterceptor {
    private static final Logger logger_ = Logger.getLogger((Class)DumpComponentTreeInterceptor.class);
    private static final long serialVersionUID = 1L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(MethodInvocation invocation) throws Throwable {
        FacesContext context = FacesContext.getCurrentInstance();
        this.printBefore(context);
        try {
            Object object = invocation.proceed();
            return object;
        }
        finally {
            this.printAfter(context);
        }
    }

    private void printAfter(FacesContext context) {
        SPrintWriter writer = new SPrintWriter();
        writer.println(((Object)((Object)this)).getClass().getName() + " after");
        this.dumpTree((PrintWriter)writer, context);
        logger_.debug((Object)writer.toString());
    }

    private void printBefore(FacesContext context) {
        SPrintWriter writer = new SPrintWriter();
        writer.println(((Object)((Object)this)).getClass().getName() + " before");
        this.dumpTree((PrintWriter)writer, context);
        logger_.debug((Object)writer.toString());
    }

    void dumpTree(PrintWriter writer, FacesContext context) {
        UIViewRoot viewRoot = context.getViewRoot();
        writer.println("[tree] " + viewRoot + " viewId=" + viewRoot.getViewId());
        this.dumpTree(writer, viewRoot, 1);
    }

    void dumpTree(PrintWriter writer, UIComponent component, int depth) {
        Iterator it = component.getFacetsAndChildren();
        while (it.hasNext()) {
            UIComponent child = (UIComponent)it.next();
            writer.print("[tree] ");
            for (int i = 0; i < depth; ++i) {
                writer.print("  ");
            }
            this.printComponent(writer, child);
            writer.println("");
            this.dumpTree(writer, child, depth + 1);
        }
    }

    private void printComponent(PrintWriter writer, UIComponent child) {
        if (child instanceof HtmlCommandLink) {
            HtmlCommandLink commandLink = (HtmlCommandLink)child;
            writer.print(commandLink);
            writer.print(" " + commandLink.getValue());
        } else if (child instanceof HtmlOutputText) {
            HtmlOutputText outputText = (HtmlOutputText)child;
            writer.print(outputText);
            writer.print(" " + outputText.getValue());
        } else {
            writer.print(child);
        }
    }
}

