/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.render;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.faces.context.FacesContext;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;
import org.seasar.framework.log.Logger;
import org.seasar.framework.util.AssertionUtil;
import org.seasar.teeda.core.util.DIContainerUtil;

public class RenderKitFactoryImpl
extends RenderKitFactory {
    private Map renderKits_ = Collections.synchronizedMap(new HashMap());
    private static Logger logger_ = Logger.getLogger((Class)RenderKitFactoryImpl.class);

    public RenderKitFactoryImpl() {
        this.initialize();
    }

    public void addRenderKit(String renderKitId, RenderKit renderKit) {
        AssertionUtil.assertNotNull((String)"renderKitId", (Object)renderKitId);
        AssertionUtil.assertNotNull((String)"renderKit", (Object)renderKit);
        this.renderKits_.put(renderKitId, renderKit);
    }

    public RenderKit getRenderKit(FacesContext context, String renderKitId) {
        AssertionUtil.assertNotNull((String)"renderKitId", (Object)renderKitId);
        RenderKit renderKit = (RenderKit)this.renderKits_.get(renderKitId);
        if (renderKit == null) {
            logger_.warn((Object)("RenderKit [" + renderKitId + "] is null."));
        }
        return renderKit;
    }

    public Iterator getRenderKitIds() {
        return this.renderKits_.keySet().iterator();
    }

    protected void initialize() {
        RenderKit renderKit = (RenderKit)DIContainerUtil.getComponentNoException(RenderKit.class);
        if (renderKit != null) {
            this.addRenderKit("HTML_BASIC", renderKit);
        }
    }
}

