/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.render.html;

import java.io.IOException;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.html.HtmlCommandButton;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.ActionEvent;
import org.seasar.framework.util.StringUtil;
import org.seasar.teeda.core.render.html.AbstractHtmlRenderer;
import org.seasar.teeda.core.util.RendererUtil;

public class HtmlCommandButtonRenderer
extends AbstractHtmlRenderer {
    public static final String COMPONENT_FAMILY = "javax.faces.Command";
    public static final String RENDERER_TYPE = "javax.faces.Button";

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        this.assertNotNull(context, component);
        if (!component.isRendered()) {
            return;
        }
        this.encodeHtmlCommandButtonEnd(context, (HtmlCommandButton)component);
    }

    protected void encodeHtmlCommandButtonEnd(FacesContext context, HtmlCommandButton htmlCommandButton) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("input", htmlCommandButton);
        String image = htmlCommandButton.getImage();
        boolean isImageType = StringUtil.isNotBlank((String)image);
        String type = isImageType ? "image" : htmlCommandButton.getType();
        RendererUtil.renderAttribute(writer, "type", (Object)type);
        RendererUtil.renderIdAttributeIfNecessary(writer, htmlCommandButton, this.getIdForRender(context, htmlCommandButton));
        RendererUtil.renderAttribute(writer, "name", (Object)htmlCommandButton.getClientId(context));
        if (isImageType) {
            RendererUtil.renderAttribute(writer, "src", image, "image");
        } else {
            RendererUtil.renderAttribute(writer, "value", htmlCommandButton.getValue());
        }
        this.renderAttributes(htmlCommandButton, writer);
        writer.endElement("input");
    }

    public void decode(FacesContext context, UIComponent component) {
        this.assertNotNull(context, component);
        this.decodeHtmlCommandButton(context, (HtmlCommandButton)component);
    }

    protected void decodeHtmlCommandButton(FacesContext context, HtmlCommandButton htmlCommandButton) {
        String clientId;
        Map paramMap = context.getExternalContext().getRequestParameterMap();
        if ((paramMap.containsKey(clientId = htmlCommandButton.getClientId(context)) || paramMap.containsKey(clientId + ".x") || paramMap.containsKey(clientId + ".y")) && !"reset".equalsIgnoreCase(htmlCommandButton.getType())) {
            htmlCommandButton.queueEvent(new ActionEvent(htmlCommandButton));
        }
    }
}

