/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.render.html.support;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.seasar.framework.exception.IORuntimeException;
import org.seasar.framework.util.ClassUtil;
import org.seasar.framework.util.ResourceUtil;
import org.seasar.framework.util.StringUtil;
import org.seasar.teeda.core.render.html.RenderAttributes;

public class RenderAttributesImpl
implements RenderAttributes {
    private static final String RENDER_ON = "1";
    private Map map = new HashMap();
    private List path = new ArrayList();

    public RenderAttributesImpl() {
        String a = ClassUtil.getPackageName((Class)RenderAttributesImpl.class).replace('.', '/') + "/renderAttributes.xls";
        this.path.add(a);
    }

    public void initialize() {
        Iterator it = this.getPath().iterator();
        while (it.hasNext()) {
            String path = (String)it.next();
            this.initWorkBook(this.createWorkbook(path));
        }
    }

    private void initWorkBook(HSSFWorkbook workbook) {
        HSSFSheet sheet = workbook.getSheetAt(0);
        HSSFRow componentFamilyRow = sheet.getRow(0);
        HSSFRow rendererTypeRow = sheet.getRow(1);
        short colIndex = 1;
        while (true) {
            HSSFRow row;
            HSSFCell componentFamilyCell = componentFamilyRow.getCell(colIndex);
            HSSFCell rendererTypeCell = rendererTypeRow.getCell(colIndex);
            if (componentFamilyCell == null || rendererTypeCell == null) break;
            ArrayList<String> names = new ArrayList<String>();
            int rowIndex = 2;
            while ((row = sheet.getRow(rowIndex)) != null) {
                String value;
                HSSFCell cell = row.getCell(colIndex);
                if (cell != null && RENDER_ON.equals(value = this.getValueAsString(cell))) {
                    String name = row.getCell((short)0).getStringCellValue().trim();
                    names.add(name);
                }
                ++rowIndex;
            }
            String componentFamily = componentFamilyCell.getStringCellValue().trim();
            String rendererType = rendererTypeCell.getStringCellValue().trim();
            String key = this.createKey(componentFamily, rendererType);
            this.map.put(key, names.toArray(new String[names.size()]));
            colIndex = (short)(colIndex + 1);
        }
    }

    private HSSFWorkbook createWorkbook(String path) {
        InputStream is = ResourceUtil.getResourceAsStream((String)path);
        try {
            return new HSSFWorkbook(is);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    private String getValueAsString(HSSFCell cell) {
        Object value = this.getValue(cell);
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    public String[] getAttributeNames(String componentFamily, String rendererType) {
        String[] names = (String[])this.map.get(this.createKey(componentFamily, rendererType));
        return names;
    }

    private String createKey(String componentFamily, String rendererType) {
        return componentFamily + "\f" + rendererType;
    }

    public Object getValue(HSSFCell cell) {
        if (cell == null) {
            return null;
        }
        switch (cell.getCellType()) {
            case 0: {
                double numericCellValue = cell.getNumericCellValue();
                if (this.isInt(numericCellValue)) {
                    return new BigDecimal((int)numericCellValue);
                }
                return new BigDecimal(Double.toString(numericCellValue));
            }
            case 1: {
                String s = cell.getStringCellValue();
                if (s != null) {
                    s = StringUtil.rtrim((String)s);
                }
                if ("".equals(s)) {
                    s = null;
                }
                return s;
            }
            case 4: {
                boolean b = cell.getBooleanCellValue();
                return b;
            }
        }
        return null;
    }

    private boolean isInt(double numericCellValue) {
        return (double)((int)numericCellValue) == numericCellValue;
    }

    public void addPath(String path) {
        this.path.add(path);
    }

    public List getPath() {
        return this.path;
    }

    public void setPath(List path) {
        this.path = path;
    }
}

