/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.taglib.core;

import javax.faces.component.ActionSource;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import javax.faces.event.ActionListener;
import javax.faces.internal.ValueBindingUtil;
import javax.faces.webapp.UIComponentTag;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;
import org.seasar.teeda.core.util.ClassUtil;

public class ActionListenerTag
extends TagSupport {
    private static final long serialVersionUID = 1L;
    private String type = null;

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public int doStartTag() throws JspException {
        UIComponentTag componentTag = UIComponentTag.getParentUIComponentTag(this.pageContext);
        if (componentTag == null) {
            throw new JspException("Not nested in a UIComponentTag");
        }
        if (!componentTag.getCreated()) {
            return 0;
        }
        UIComponent component = componentTag.getComponentInstance();
        if (!(component instanceof ActionSource)) {
            throw new JspException("Component:" + component + " is not instance of ActionSource");
        }
        String className = this.getActionListenerClassName();
        ActionListener actionListener = this.createActionListener(className);
        ((ActionSource)((Object)component)).addActionListener(actionListener);
        return 0;
    }

    public void release() {
        this.type = null;
    }

    protected String getActionListenerClassName() {
        String className = this.type;
        if (UIComponentTag.isValueReference(this.type)) {
            FacesContext context = FacesContext.getCurrentInstance();
            ValueBinding vb = ValueBindingUtil.createValueBinding(context, this.type);
            className = (String)vb.getValue(context);
        }
        return className;
    }

    protected ActionListener createActionListener(String className) {
        return (ActionListener)ClassUtil.newInstance(className);
    }
}

