/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.util;

import java.text.MessageFormat;
import java.util.ResourceBundle;
import org.seasar.framework.util.ArrayUtil;

public class MessageFormatterUtil {
    private MessageFormatterUtil() {
    }

    public static String getMessage(String messageCode, Object[] args) {
        if (messageCode == null) {
            messageCode = "";
        }
        return MessageFormatterUtil.getFormattedMessage(messageCode, args);
    }

    public static String getSimpleMessage(String messageCode, Object[] args) {
        try {
            String pattern = MessageFormatterUtil.getPattern(messageCode);
            if (pattern != null) {
                return MessageFormat.format(pattern, args);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return MessageFormatterUtil.getNoPatternMessage(args);
    }

    private static String getPattern(String messageCode) {
        ResourceBundle resourceBundle = MessageFormatterUtil.getMessages(MessageFormatterUtil.getSystemName(messageCode));
        if (resourceBundle != null) {
            return resourceBundle.getString(messageCode);
        }
        return null;
    }

    private static String getSystemName(String messageCode) {
        return messageCode.substring(1, Math.min(4, messageCode.length()));
    }

    private static ResourceBundle getMessages(String systemName) {
        return ResourceBundle.getBundle(systemName + "Messages");
    }

    private static String getNoPatternMessage(Object[] args) {
        String delimeter = ", ";
        if (ArrayUtil.isEmpty((Object[])args)) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < args.length; ++i) {
            buffer.append(args[i] + ", ");
        }
        buffer.setLength(buffer.length() - ", ".length());
        return buffer.toString();
    }

    public static String getFormattedMessage(String messageCode, Object[] args) {
        return MessageFormatterUtil.getFormattedMessage(messageCode, MessageFormatterUtil.getSimpleMessage(messageCode, args));
    }

    public static String getFormattedMessage(String messageCode, String simpleMessage) {
        return "[" + messageCode + "]" + simpleMessage;
    }
}

