/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.component.html.ext;

import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.faces.context.FacesContext;
import javax.faces.el.ReferenceSyntaxException;
import javax.faces.model.ArrayDataModel;
import javax.faces.model.DataModel;
import javax.faces.model.ListDataModel;
import javax.faces.model.ResultDataModel;
import javax.faces.model.ResultSetDataModel;
import javax.faces.model.ScalarDataModel;
import javax.servlet.jsp.el.ELException;
import javax.servlet.jsp.el.FunctionMapper;
import javax.servlet.jsp.el.VariableResolver;
import javax.servlet.jsp.jstl.sql.Result;
import org.apache.commons.el.Expression;
import org.apache.commons.el.ExpressionString;
import org.apache.commons.el.Logger;
import org.apache.commons.el.parser.ELParser;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.component.html.ext.SortCriterion;
import org.apache.myfaces.component.html.ext._SerializableDataModel;

public final class SortableModel
extends DataModel
implements VariableResolver {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$myfaces$component$html$ext$SortableModel == null ? (class$org$apache$myfaces$component$html$ext$SortableModel = SortableModel.class$("org.apache.myfaces.component.html.ext.SortableModel")) : class$org$apache$myfaces$component$html$ext$SortableModel));
    public static final Logger LOGGER = new Logger(System.out);
    private static final String ROW_OBJECT_NAME = "rowObjectGet";
    private SortCriterion _sortCriterion = null;
    private DataModel _model = null;
    private Object _wrappedData = null;
    private IntList _sortedIndicesList = null;
    private IntList _baseIndicesList = null;
    private static final Class OBJECT_ARRAY_CLASS = new Object[0].getClass();
    protected static FunctionMapper s_functionMapper = new FunctionMapper(){

        public Method resolveFunction(String prefix, String localName) {
            throw new ReferenceSyntaxException("Functions not supported in expressions. Function: " + prefix + ":" + localName);
        }
    };
    private static final DataModel EMPTY_DATA_MODEL = new _SerializableDataModel(){

        public boolean isRowAvailable() {
            return false;
        }

        public int getRowCount() {
            return 0;
        }

        public Object getRowData() {
            throw new IllegalArgumentException();
        }

        public int getRowIndex() {
            return -1;
        }

        public void setRowIndex(int i) {
            if (i < -1) {
                throw new IndexOutOfBoundsException("Index < 0 : " + i);
            }
        }

        public Object getWrappedData() {
            return null;
        }

        public void setWrappedData(Object obj) {
            if (obj == null) {
                return;
            }
            throw new UnsupportedOperationException(this.getClass().getName() + " UnsupportedOperationException");
        }
    };
    static /* synthetic */ Class class$org$apache$myfaces$component$html$ext$SortableModel;

    public SortableModel(Object model) {
        this.setWrappedData(model);
    }

    public SortableModel() {
    }

    public Object getRowData() {
        return this._model.getRowData();
    }

    public Object getWrappedData() {
        return this._wrappedData;
    }

    public boolean isRowAvailable() {
        return this._model.isRowAvailable();
    }

    public void setWrappedData(Object data) {
        this._baseIndicesList = null;
        this._model = this.toDataModel(data);
        this._sortCriterion = null;
        this._sortedIndicesList = null;
        this._wrappedData = data;
    }

    protected DataModel toDataModel(Object data) {
        if (data == null) {
            return EMPTY_DATA_MODEL;
        }
        if (data instanceof DataModel) {
            return (DataModel)data;
        }
        if (data instanceof List) {
            return new ListDataModel((List)data);
        }
        if (data instanceof Collection) {
            return new ListDataModel(new ArrayList((Collection)data));
        }
        if (OBJECT_ARRAY_CLASS.isAssignableFrom(data.getClass())) {
            return new ArrayDataModel((Object[])data);
        }
        if (data instanceof ResultSet) {
            return new ResultSetDataModel((ResultSet)data);
        }
        if (data instanceof Result) {
            return new ResultDataModel((Result)data);
        }
        return new ScalarDataModel(data);
    }

    public int getRowCount() {
        return this._model.getRowCount();
    }

    public void setRowIndex(int rowIndex) {
        int baseIndex = this._toBaseIndex(rowIndex);
        this._model.setRowIndex(baseIndex);
    }

    public int getRowIndex() {
        int baseIndex = this._model.getRowIndex();
        return this._toSortedIndex(baseIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSortable(String property) {
        int oldIndex = this._model.getRowIndex();
        try {
            this._model.setRowIndex(0);
            if (!this._model.isRowAvailable()) {
                boolean bl = false;
                return bl;
            }
            Object propertyValue = this.getPropertyValue(property);
            boolean bl = propertyValue instanceof Comparable || propertyValue == null;
            return bl;
        }
        finally {
            this._model.setRowIndex(oldIndex);
        }
    }

    public List getSortCriteria() {
        return this._sortCriterion == null ? Collections.EMPTY_LIST : Collections.singletonList(this._sortCriterion);
    }

    public void setSortCriteria(List criteria) {
        if (criteria == null || criteria.isEmpty()) {
            this._sortCriterion = null;
            this._sortedIndicesList = null;
            this._baseIndicesList = null;
        } else {
            SortCriterion sc = (SortCriterion)criteria.get(0);
            if (this._sortCriterion == null || !this._sortCriterion.equals(sc)) {
                this._sortCriterion = sc;
                this._sort(this._sortCriterion.getProperty(), this._sortCriterion.isAscending());
            }
        }
    }

    public String toString() {
        return "SortableModel[" + this._model + "]";
    }

    private void _sort(String property, boolean isAscending) {
        int sz = this.getRowCount();
        if (this._baseIndicesList == null || this._baseIndicesList.size() != sz) {
            this._baseIndicesList = new IntList(sz);
        }
        int rowIndex = this._model.getRowIndex();
        this._model.setRowIndex(0);
        if (this._model.isRowAvailable()) {
            Comparator comp = new Comp(property);
            if (!isAscending) {
                comp = new Inverter(comp);
            }
            Collections.sort(this._baseIndicesList, comp);
            this._sortedIndicesList = null;
        }
        this._model.setRowIndex(rowIndex);
    }

    private int _toSortedIndex(int baseIndex) {
        if (this._sortedIndicesList == null && this._baseIndicesList != null) {
            this._sortedIndicesList = (IntList)this._baseIndicesList.clone();
            for (int i = 0; i < this._baseIndicesList.size(); ++i) {
                Integer base = (Integer)this._baseIndicesList.get(i);
                this._sortedIndicesList.set(base, new Integer(i));
            }
        }
        return this._convertIndex(baseIndex, this._sortedIndicesList);
    }

    private int _toBaseIndex(int sortedIndex) {
        return this._convertIndex(sortedIndex, this._baseIndicesList);
    }

    private int _convertIndex(int index, List indices) {
        if (index < 0) {
            return index;
        }
        if (indices != null && indices.size() > index) {
            index = (Integer)indices.get(index);
        }
        return index;
    }

    protected Object getPropertyValue(String property) {
        String expressionString = "${rowObjectGet." + property + "}";
        ELParser parser = new ELParser((Reader)new StringReader(expressionString));
        try {
            Object expression = parser.ExpressionString();
            if (!(expression instanceof Expression) && !(expression instanceof ExpressionString)) {
                return null;
            }
            Object value = expression instanceof Expression ? ((Expression)expression).evaluate((VariableResolver)this, s_functionMapper, LOGGER) : ((ExpressionString)expression).evaluate((VariableResolver)this, s_functionMapper, LOGGER);
            return value;
        }
        catch (Exception exc) {
            log.error((Object)"Evaluate:", (Throwable)exc);
            return null;
        }
    }

    public Object resolveVariable(String pName) throws ELException {
        if (ROW_OBJECT_NAME.equals(pName)) {
            return this._model.getRowData();
        }
        FacesContext context = FacesContext.getCurrentInstance();
        return context.getApplication().getVariableResolver().resolveVariable(context, pName);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static final class Inverter
    implements Comparator {
        private final Comparator _comp;

        public Inverter(Comparator comp) {
            this._comp = comp;
        }

        public int compare(Object o1, Object o2) {
            return this._comp.compare(o2, o1);
        }
    }

    private final class Comp
    implements Comparator {
        private final String _prop;

        public Comp(String property) {
            this._prop = property;
        }

        public int compare(Object o1, Object o2) {
            int index1 = (Integer)o1;
            int index2 = (Integer)o2;
            SortableModel.this._model.setRowIndex(index1);
            Object value1 = SortableModel.this.getPropertyValue(this._prop);
            SortableModel.this._model.setRowIndex(index2);
            Object value2 = SortableModel.this.getPropertyValue(this._prop);
            if (value1 == null) {
                return value2 == null ? 0 : -1;
            }
            if (value2 == null) {
                return 1;
            }
            if (value1 instanceof Comparable) {
                return ((Comparable)value1).compareTo(value2);
            }
            return value1.toString().compareTo(value2.toString());
        }
    }

    private static final class IntList
    extends ArrayList
    implements Cloneable {
        public IntList(int size) {
            super(size);
            this._expandToSize(size);
        }

        private void _expandToSize(int desiredSize) {
            for (int i = 0; i < desiredSize; ++i) {
                this.add(new Integer(i));
            }
        }
    }
}

