/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.grizzly.pipeline.valve.impl;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import jp.sf.grizzly.pipeline.PipelineException;
import jp.sf.grizzly.pipeline.valve.AbstractValve;
import jp.sf.grizzly.pipeline.valve.ValveContext;
import jp.sf.grizzly.storage.StreamStorage;
import jp.sf.grizzly.storage.StreamStorageException;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UnescapeJavaValve
extends AbstractValve {
    private static final Log log = LogFactory.getLog((Class)UnescapeJavaValve.class);

    public void invoke(StreamStorage storage, ValveContext context) throws PipelineException {
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(storage.getInputStream(), storage.getEncoding()));
        }
        catch (UnsupportedEncodingException e) {
            log.warn((Object)"Unsupported Encoding. ", (Throwable)e);
            reader = new BufferedReader(new InputStreamReader(storage.getInputStream()));
        }
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(storage.getOutputStream()));
        String line = null;
        try {
            while ((line = reader.readLine()) != null) {
                writer.write(StringEscapeUtils.unescapeJava((String)line));
                writer.write("\n");
            }
            writer.flush();
            storage.commit();
        }
        catch (StreamStorageException e) {
            log.error((Object)"Stream Storage Exception. ", (Throwable)e);
            throw new PipelineException((Throwable)e);
        }
        catch (IOException e) {
            log.error((Object)"Stream Storage Exception. ", (Throwable)e);
            throw new PipelineException((Throwable)e);
        }
        context.invokeNext(storage);
    }
}

