<%@ page contentType="text/html; charset=UTF-8"%>
<%@ taglib uri="http://java.sun.com/jsf/html" prefix="h"%>
<%@ taglib uri="http://java.sun.com/jsf/core" prefix="f"%>
<%@ taglib uri="http://myfaces.apache.org/tomahawk" prefix="t"%>
<f:view>
	<f:loadBundle
		basename="jp.sf.pal.blog.resources.BlogTitleViewResources" var="msgs" />
	<h:form>
		<t:dataTable id="titleView" var="blogMsg"
			value="#{titleViewPage.blogMessages}"
			headerClass="portlet-section-header"
			rowClasses="portlet-section-body,portlet-section-alternate"
			style="width:100%" rows="#{titleViewSession.pageSize}">
			<h:column>
				<f:facet name="header">
					<h:outputText value="#{msgs['blogtitleview.TitleColumn']}" />
				</f:facet>
				<h:commandLink action="#{titleViewPage.select}">
					<f:verbatim>
						<h:outputText value="#{blogMsg['0'].abbreviatedTitle}" />
						<h:outputText value="#{msgs['blogtitleview.NoTitle']}"
							rendered="#{blogMsg['0'].emptyTitle}" />
					</f:verbatim>
				</h:commandLink>
			</h:column>
			<h:column rendered="#{titleViewSession.displayCreatedtime}">
				<f:facet name="header">
					<h:outputText value="#{msgs['blogtitleview.CreatedDateColumn']}" />
				</f:facet>
				<h:outputText value="#{blogMsg['0'].formattedCreatedtime}" />
			</h:column>
			<h:column rendered="#{titleViewSession.displayUpdatedtime}">
				<f:facet name="header">
					<h:outputText value="#{msgs['blogtitleview.UpdatedDateColumn']}" />
				</f:facet>
				<h:outputText value="#{blogMsg['0'].formattedUpdatedtime}" />
			</h:column>
		</t:dataTable>
		<h:panelGrid columns="1" styleClass="portlet-section-footer"
			style="width:100%">
			<t:dataScroller for="titleView" fastStep="10"
				pageCountVar="pageCount" pageIndexVar="pageIndex" paginator="true"
				paginatorMaxPages="5">
				<f:facet name="first">
					<t:graphicImage url="/images/arrow-first.gif" border="1"
						rendered="#{pageIndex!=1}" />
				</f:facet>
				<f:facet name="last">
					<t:graphicImage url="/images/arrow-last.gif" border="1"
						rendered="#{pageIndex<pageCount}" />
				</f:facet>
				<f:facet name="previous">
					<t:graphicImage url="/images/arrow-previous.gif" border="1"
						rendered="#{pageIndex!=1}" />
				</f:facet>
				<f:facet name="next">
					<t:graphicImage url="/images/arrow-next.gif" border="1"
						rendered="#{pageIndex<pageCount}" />
				</f:facet>
			</t:dataScroller>
			<t:dataScroller for="titleView" rowsCountVar="rowsCount"
				displayedRowsCountVar="displayedRowsCountVar"
				pageCountVar="pageCount" immediate="true" pageIndexVar="pageIndex">
				<h:outputFormat
					value="#{msgs['blogtitleview.FoundDisplayingItemsFromToPage']}"
					rendered="#{rowsCount!=0}">
					<f:param value="#{rowsCount}" />
					<f:param value="#{pageIndex}" />
					<f:param value="#{pageCount}" />
				</h:outputFormat>
				<h:outputText value="#{msgs['blogtitleview.NoItems']}"
					rendered="#{rowsCount==0}" />
			</t:dataScroller>
		</h:panelGrid>
	</h:form>
</f:view>
