<%@ page contentType="text/html; charset=UTF-8"%>
<%@ taglib uri="http://java.sun.com/jsf/html" prefix="h"%>
<%@ taglib uri="http://java.sun.com/jsf/core" prefix="f"%>
<%@ taglib uri="http://myfaces.apache.org/tomahawk" prefix="t"%>
<f:view>
	<f:loadBundle
		basename="jp.sf.pal.blog.resources.BlogTrackbackTitleViewResources"
		var="msgs" />
	<h:form>
		<h:messages styleClass="portlet-msg-success"
			errorClass="portlet-msg-error" fatalClass="portlet-msg-error"
			warnClass="portlet-msg-alert" infoClass="portlet-msg-info" />
		<h:panelGrid border="0" columns="2">
			<h:outputLabel for="targetUser">
				<h:outputText
					value="#{msgs['blogtrackbacktitleview.TargetUserNameLable']}"
					styleClass="portlet-form-field" />
			</h:outputLabel>
			<h:inputText id="targetUser"
				value="#{trackbackTitleViewEditPage.owner}" size="30"
				styleClass="portlet-form-field-label" />

			<h:outputLabel for="number">
				<h:outputText
					value="#{msgs['blogtrackbacktitleview.TheNumberOfBlogItemLabel']}"
					styleClass="portlet-form-field" />
			</h:outputLabel>
			<h:inputText id="number"
				value="#{trackbackTitleViewEditPage.pageSize}" size="30"
				styleClass="portlet-form-field-label"
				converter="javax.faces.Integer" required="true">
				<f:validateLongRange minimum="1" />
			</h:inputText>

			<h:outputLabel for="displayedItems">
				<h:outputText
					value="#{msgs['blogtrackbacktitleview.DisplayedItemsLabel']}"
					styleClass="portlet-form-field" />
			</h:outputLabel>
			<h:selectManyCheckbox id="displayedItems"
				value="#{trackbackTitleViewEditPage.displayedItems}"
				styleClass="portlet-form-field">
				<f:selectItem itemValue="createdtime"
					itemLabel="#{msgs['blogtrackbacktitleview.CreatedDateSelect']}" />
			</h:selectManyCheckbox>

			<h:commandButton action="#{trackbackTitleViewEditPage.save}"
				value="#{msgs['blogtrackbacktitleview.SaveButton']}"
				styleClass="portlet-form-button" />
			<h:commandButton action="#{trackbackTitleViewEditPage.reset}"
				value="#{msgs['blogtrackbacktitleview.ResetButton']}"
				styleClass="portlet-form-button" />
		</h:panelGrid>
	</h:form>
</f:view>
