/*
 * Copyright 2005-2006 The Portal Application Laboratory Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.pal.notepad.bean;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.ArrayList;
import java.util.List;

import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;

import jp.sf.pal.notepad.NotepadConstants;
import jp.sf.pal.notepad.NotepadRuntimeException;
import jp.sf.pal.notepad.model.Category;
import jp.sf.pal.notepad.util.NotepadDaoUtil;

import org.seasar.portlet.util.PortletResourceBundleUtil;

import com.marevol.utils.faces.util.LocaleUtil;

public class NotepadMenuPageBean
{
    /**
     * Logger for this class
     */
    private static final Log log = LogFactory.getLog(NotepadMenuPageBean.class);

    private NotepadSessionBean notepadSession;

    private Long categoryId;

    private Boolean validUser;

    public String selectCategory()
    {
        getNotepadSession().setCategoryId(getCategoryId());
        return NotepadConstants.NOTEPAD_VIEW_VIEW_ID;
    }

    public String editCategories()
    {
        return NotepadConstants.CATEGORY_VIEW_VIEW_ID;
    }

    public String createNote()
    {
        return NotepadConstants.NOTEPAD_ADD_VIEW_ID;
    }

    public SelectItem[] getCategoryItems()
    {
        if (log.isDebugEnabled())
        {
            log.debug("getCategoryItems() - start");
        }

        ArrayList list = new ArrayList();
        try
        {
            // i18n
            list.add(new SelectItem(new Long(-1), PortletResourceBundleUtil.getString(LocaleUtil.getLocale(),
                    "notepadmenu.All")));

            String username = FacesContext.getCurrentInstance().getExternalContext().getRemoteUser();
            if (username != null)
            {
                List categories = NotepadDaoUtil.getCategoryDao().getCategoryByScopeOwner(getNotepadSession().getScope(),
                        username);
                if (categories.size() > 0)
                {
                    for (int i = 0; i < categories.size(); i++)
                    {
                        Category cat = (Category) categories.get(i);
                        list.add(new SelectItem(new Long(cat.getId()), cat.getName()));
                    }
                }
            }
        }
        catch (RuntimeException e)
        {
         log.error(e);
        }

        SelectItem[] items = new SelectItem[list.size()];
        for (int i = 0; i < list.size(); i++)
        {
            items[i] = (SelectItem) list.get(i);
        }

        if (log.isDebugEnabled())
        {
            log.debug("getCategoryItems() - end");
        }
        return items;
    }

    /**
     * @return Returns the categoryId.
     */
    public Long getCategoryId()
    {
        return categoryId;
    }

    /**
     * @param categoryId The categoryId to set.
     */
    public void setCategoryId(Long categoryId)
    {
        this.categoryId = categoryId;
    }

    /**
     * @return Returns the notepadSession.
     */
    public NotepadSessionBean getNotepadSession()
    {
        return notepadSession;
    }

    /**
     * @param notepadSession The notepadSession to set.
     */
    public void setNotepadSession(NotepadSessionBean notepadSession)
    {
        this.notepadSession = notepadSession;
        if (notepadSession != null)
        {
            categoryId = notepadSession.getCategoryId();
        }
    }

    /**
     * @return Returns the validUser.
     */
    public Boolean getValidUser()
    {
        if (validUser == null)
        {
            if (FacesContext.getCurrentInstance().getExternalContext().getRemoteUser() != null)
            {
                validUser = Boolean.TRUE;
            }
            else
            {
                validUser = Boolean.FALSE;
            }
        }
        return validUser;
    }

    /**
     * @param validUser The validUser to set.
     */
    public void setValidUser(Boolean validUser)
    {
        this.validUser = validUser;
    }
}
