/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.application;

import java.io.IOException;
import java.io.Serializable;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;

public abstract class StateManager {
    public static final String STATE_SAVING_METHOD_CLIENT = "client";
    public static final String STATE_SAVING_METHOD_SERVER = "server";
    public static final String STATE_SAVING_METHOD_PARAM_NAME = "javax.faces.STATE_SAVING_METHOD";

    public abstract SerializedView saveSerializedView(FacesContext var1);

    public abstract void writeState(FacesContext var1, SerializedView var2) throws IOException;

    protected abstract Object getTreeStructureToSave(FacesContext var1);

    protected abstract Object getComponentStateToSave(FacesContext var1);

    public abstract UIViewRoot restoreView(FacesContext var1, String var2, String var3);

    protected abstract UIViewRoot restoreTreeStructure(FacesContext var1, String var2, String var3);

    protected abstract void restoreComponentState(FacesContext var1, UIViewRoot var2, String var3);

    public boolean isSavingStateInClient(FacesContext context) {
        String state = StateManager.getSavingState(context);
        return STATE_SAVING_METHOD_CLIENT.equalsIgnoreCase(state);
    }

    private static String getSavingState(FacesContext context) {
        return context.getExternalContext().getInitParameter(STATE_SAVING_METHOD_PARAM_NAME);
    }

    public class SerializedView
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private Object structure_ = null;
        private Object state_ = null;

        public SerializedView(Object structure, Object state) {
            this.structure_ = structure;
            this.state_ = state;
        }

        public Object getState() {
            return this.state_;
        }

        public Object getStructure() {
            return this.structure_;
        }
    }
}

