/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.validator;

import javax.faces.FacesException;
import javax.faces.component.StateHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.internal.FacesMessageUtil;
import javax.faces.internal.UIComponentUtil;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;
import org.seasar.framework.util.AssertionUtil;

public class LengthValidator
implements Validator,
StateHolder {
    public static final String VALIDATOR_ID = "javax.faces.Length";
    public static final String MAXIMUM_MESSAGE_ID = "javax.faces.validator.LengthValidator.MAXIMUM";
    public static final String MINIMUM_MESSAGE_ID = "javax.faces.validator.LengthValidator.MINIMUM";
    private Integer maximum = null;
    private Integer minimum = null;
    private boolean transientValue = false;

    public LengthValidator() {
    }

    public LengthValidator(int maximum) {
        this.maximum = new Integer(maximum);
    }

    public LengthValidator(int maximum, int minimum) {
        this.maximum = new Integer(maximum);
        this.minimum = new Integer(minimum);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof LengthValidator)) {
            return false;
        }
        LengthValidator v = (LengthValidator)obj;
        if (this.maximum != null && v.maximum == null && this.maximum == null && v.maximum != null) {
            return false;
        }
        if (this.minimum != null && v.minimum == null && this.minimum == null && v.minimum != null) {
            return false;
        }
        return this.getMaximum() == v.getMaximum() && this.getMinimum() == v.getMinimum();
    }

    public int hashCode() {
        Integer max = this.maximum != null ? this.maximum : new Integer(1);
        Integer min = this.minimum != null ? this.minimum : new Integer(1);
        return max.hashCode() * min.hashCode() * 17;
    }

    public int getMaximum() {
        return this.maximum != null ? this.maximum : 0;
    }

    public int getMinimum() {
        return this.minimum != null ? this.minimum : 0;
    }

    public void setMaximum(int maximum) {
        this.maximum = new Integer(maximum);
    }

    public void setMinimum(int minimum) {
        this.minimum = new Integer(minimum);
    }

    public boolean isTransient() {
        return this.transientValue;
    }

    public void validate(FacesContext context, UIComponent component, Object value) throws FacesException {
        AssertionUtil.assertNotNull((String)"context", (Object)context);
        AssertionUtil.assertNotNull((String)"component", (Object)component);
        if (value == null) {
            return;
        }
        int length = this.getConvertedValueLength(value);
        if (this.minimum != null && length < this.minimum) {
            Object[] args = new Object[]{this.minimum, UIComponentUtil.getLabel(component)};
            throw new ValidatorException(FacesMessageUtil.getMessage(context, this.getMinimumMessageId(), args));
        }
        if (this.maximum != null && length > this.maximum) {
            Object[] args = new Object[]{this.maximum, UIComponentUtil.getLabel(component)};
            throw new ValidatorException(FacesMessageUtil.getMessage(context, this.getMaximumMessageId(), args));
        }
    }

    public void setTransient(boolean transientValue) {
        this.transientValue = transientValue;
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{this.maximum, this.minimum};
        return values;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        this.maximum = (Integer)values[0];
        this.minimum = (Integer)values[1];
    }

    protected int getConvertedValueLength(Object value) {
        int length = 0;
        length = value instanceof String ? ((String)value).length() : value.toString().length();
        return length;
    }

    protected String getMinimumMessageId() {
        return MINIMUM_MESSAGE_ID;
    }

    protected String getMaximumMessageId() {
        return MAXIMUM_MESSAGE_ID;
    }
}

