/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.render;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import javax.faces.application.StateManager;
import javax.faces.context.FacesContext;
import javax.faces.internal.FacesConfigOptions;
import org.seasar.framework.util.Base64Util;
import org.seasar.framework.util.InputStreamUtil;
import org.seasar.teeda.core.render.AbstractResponseStateManager;
import org.seasar.teeda.core.render.EncodeConverter;
import org.seasar.teeda.core.util.GZIPInputStreamUtil;
import org.seasar.teeda.core.util.GZIPOutputStreamUtil;
import org.seasar.teeda.core.util.ObjectInputStreamUtil;
import org.seasar.teeda.core.util.ObjectOutputStreamUtil;
import org.seasar.teeda.core.util.OutputStreamUtil;

public class Base64EncodeConverter
implements EncodeConverter {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAsEncodeString(Object target) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        OutputStream out = null;
        ObjectOutputStream oos = null;
        try {
            if (this.isCompressRequested()) {
                out = GZIPOutputStreamUtil.getOutputStream(bos);
                oos = ObjectOutputStreamUtil.getOutputStream(out);
            } else {
                oos = ObjectOutputStreamUtil.getOutputStream(bos);
            }
            if (target instanceof StateManager.SerializedView) {
                StateManager.SerializedView view = (StateManager.SerializedView)target;
                ObjectOutputStreamUtil.writeObject(oos, view.getStructure());
                ObjectOutputStreamUtil.writeObject(oos, view.getState());
            } else {
                ObjectOutputStreamUtil.writeObject(oos, target);
            }
            String string = Base64Util.encode((byte[])bos.toByteArray());
            return string;
        }
        finally {
            if (oos != null) {
                ObjectOutputStreamUtil.reset(oos);
                OutputStreamUtil.close(oos);
            }
            OutputStreamUtil.close(out);
            OutputStreamUtil.close(bos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getAsDecodeObject(String state) {
        Object object;
        byte[] bytes = Base64Util.decode((String)state);
        ByteArrayInputStream bis = null;
        InputStream is = null;
        Object structure = null;
        Object viewState = null;
        ObjectInputStream ois = null;
        try {
            bis = new ByteArrayInputStream(bytes);
            if (this.isCompressRequested()) {
                is = GZIPInputStreamUtil.getInputStream(bis);
                ois = ObjectInputStreamUtil.getInputStream(is);
            } else {
                ois = ObjectInputStreamUtil.getInputStream(bis);
            }
            structure = ObjectInputStreamUtil.readObject(ois);
            viewState = ObjectInputStreamUtil.readObject(ois);
            this.storeViewState(viewState);
            object = structure;
        }
        catch (Throwable throwable) {
            InputStreamUtil.close(ois);
            InputStreamUtil.close(is);
            InputStreamUtil.close((InputStream)bis);
            throw throwable;
        }
        InputStreamUtil.close((InputStream)ois);
        InputStreamUtil.close((InputStream)is);
        InputStreamUtil.close((InputStream)bis);
        return object;
    }

    protected boolean isCompressRequested() {
        return FacesConfigOptions.getCompressState();
    }

    protected void storeViewState(Object viewState) {
        FacesContext context = FacesContext.getCurrentInstance();
        context.getExternalContext().getRequestMap().put(AbstractResponseStateManager.FACES_VIEW_STATE, viewState);
    }
}

