/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.render.html;

import java.io.IOException;
import java.util.Map;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.internal.UIComponentUtil;
import org.seasar.teeda.core.render.html.AbstractHtmlRenderer;
import org.seasar.teeda.core.util.RendererUtil;

public abstract class AbstractHtmlMessagesRenderer
extends AbstractHtmlRenderer {
    protected void renderOneMessage(FacesContext context, UIComponent component, FacesMessage facesMassage, String idForRender, Map attributes) throws IOException {
        boolean isWriteDetail;
        String style = this.getStyle(component, facesMassage.getSeverity());
        String styleClass = this.getStyleClass(component, facesMassage.getSeverity());
        String title = this.getTitle(component);
        String summary = facesMassage.getSummary();
        String detail = facesMassage.getDetail();
        boolean isWriteSummary = this.isShowSummary(component) && summary != null;
        boolean bl = isWriteDetail = this.isShowDetail(component) && detail != null;
        if (this.isTooltip(component) && isWriteSummary && isWriteDetail) {
            isWriteSummary = false;
            title = summary;
        }
        ResponseWriter writer = context.getResponseWriter();
        boolean startSpan = false;
        if (idForRender != null || style != null || styleClass != null || title != null || this.containsAttributeForRender(attributes)) {
            startSpan = true;
            writer.startElement("span", component);
            RendererUtil.renderAttribute(writer, "id", (Object)idForRender);
            RendererUtil.renderAttribute(writer, "title", (Object)title);
            RendererUtil.renderAttribute(writer, "style", (Object)style);
            RendererUtil.renderAttribute(writer, "styleClass", (Object)styleClass);
            this.renderAttributes(attributes, writer);
        }
        if (isWriteSummary) {
            writer.write(summary);
        }
        if (isWriteDetail) {
            if (isWriteSummary) {
                writer.write(" ");
            }
            writer.write(detail);
        }
        if (startSpan) {
            writer.endElement("span");
        }
    }

    protected boolean isTooltip(UIComponent component) {
        return UIComponentUtil.getPrimitiveBooleanAttribute(component, "tooltip");
    }

    protected boolean isShowDetail(UIComponent component) {
        return UIComponentUtil.getPrimitiveBooleanAttribute(component, "showDetail");
    }

    protected boolean isShowSummary(UIComponent component) {
        return UIComponentUtil.getPrimitiveBooleanAttribute(component, "showSummary");
    }

    protected String getTitle(UIComponent component) {
        return UIComponentUtil.getStringAttribute(component, "title");
    }

    protected String getStyleClass(UIComponent component, FacesMessage.Severity severity) {
        String styleClass = null;
        if (severity == FacesMessage.SEVERITY_INFO) {
            styleClass = UIComponentUtil.getStringAttribute(component, "infoClass");
        } else if (severity == FacesMessage.SEVERITY_WARN) {
            styleClass = UIComponentUtil.getStringAttribute(component, "warnClass");
        } else if (severity == FacesMessage.SEVERITY_ERROR) {
            styleClass = UIComponentUtil.getStringAttribute(component, "errorClass");
        } else if (severity == FacesMessage.SEVERITY_FATAL) {
            styleClass = UIComponentUtil.getStringAttribute(component, "fatalClass");
        }
        if (styleClass == null) {
            styleClass = UIComponentUtil.getStringAttribute(component, "styleClass");
        }
        return styleClass;
    }

    protected String getStyle(UIComponent component, FacesMessage.Severity severity) {
        String style = null;
        if (severity == FacesMessage.SEVERITY_INFO) {
            style = UIComponentUtil.getStringAttribute(component, "infoStyle");
        } else if (severity == FacesMessage.SEVERITY_WARN) {
            style = UIComponentUtil.getStringAttribute(component, "warnStyle");
        } else if (severity == FacesMessage.SEVERITY_ERROR) {
            style = UIComponentUtil.getStringAttribute(component, "errorStyle");
        } else if (severity == FacesMessage.SEVERITY_FATAL) {
            style = UIComponentUtil.getStringAttribute(component, "fatalStyle");
        }
        if (style == null) {
            style = UIComponentUtil.getStringAttribute(component, "style");
        }
        return style;
    }
}

