/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.render.html;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import javax.faces.context.ResponseStream;
import javax.faces.context.ResponseWriter;
import javax.faces.render.Renderer;
import javax.faces.render.ResponseStateManager;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.util.AssertionUtil;
import org.seasar.teeda.core.application.ComponentLookupStrategy;
import org.seasar.teeda.core.context.html.HtmlResponseWriter;
import org.seasar.teeda.core.render.AbstractRenderKit;
import org.seasar.teeda.core.render.html.support.HtmlRenderKitKeyGenerateUtil;
import org.seasar.teeda.core.util.HtmlRenderKitUtil;

public class HtmlRenderKitImpl
extends AbstractRenderKit {
    private static String DEFAULT_CONTENTTYPE = "text/html";
    private ResponseStateManager responseStateManager;
    private S2Container container;
    private ComponentLookupStrategy componentLookupStrategy;

    public void addRenderer(String family, String renderType, Renderer renderer) {
        AssertionUtil.assertNotNull((String)"family", (Object)family);
        AssertionUtil.assertNotNull((String)"renderType", (Object)renderType);
        AssertionUtil.assertNotNull((String)"renderer", (Object)renderer);
        String key = HtmlRenderKitKeyGenerateUtil.getGeneratedKey(family, renderType);
        this.getContainer().register((Object)renderer, key);
    }

    public Renderer getRenderer(String family, String renderType) {
        AssertionUtil.assertNotNull((String)"family", (Object)family);
        AssertionUtil.assertNotNull((String)"renderType", (Object)renderType);
        String key = HtmlRenderKitKeyGenerateUtil.getGeneratedKey(family, renderType);
        return (Renderer)this.componentLookupStrategy.getComponentByName(key);
    }

    public ResponseStream createResponseStream(final OutputStream out) {
        return new ResponseStream(){

            public void write(int b) throws IOException {
                out.write(b);
            }

            public void close() throws IOException {
                out.close();
            }

            public void flush() throws IOException {
                out.flush();
            }

            public void write(byte[] bytes) throws IOException {
                out.write(bytes, 0, bytes.length);
            }

            public void write(byte[] bytes, int off, int len) throws IOException {
                out.write(bytes, off, len);
            }
        };
    }

    public ResponseWriter createResponseWriter(Writer writer, String contentTypeList, String characterEncoding) {
        HtmlResponseWriter htmlResponseWriter = new HtmlResponseWriter();
        htmlResponseWriter.setWriter(writer);
        String contentType = HtmlRenderKitUtil.getContentType(contentTypeList);
        if (contentType == null) {
            contentType = DEFAULT_CONTENTTYPE;
        }
        htmlResponseWriter.setContentType(contentType);
        htmlResponseWriter.setCharacterEncoding(characterEncoding);
        return htmlResponseWriter;
    }

    public ResponseStateManager getResponseStateManager() {
        return this.responseStateManager;
    }

    public void setResponseStateManager(ResponseStateManager responseStateManager) {
        this.responseStateManager = responseStateManager;
    }

    public void setContainer(S2Container container) {
        this.container = container;
    }

    public S2Container getContainer() {
        return this.container;
    }

    public ComponentLookupStrategy getComponentLookupStrategy() {
        return this.componentLookupStrategy;
    }

    public void setComponentLookupStrategy(ComponentLookupStrategy componentLookupStrategy) {
        this.componentLookupStrategy = componentLookupStrategy;
    }
}

