/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.util;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Iterator;
import org.seasar.framework.exception.IORuntimeException;
import org.seasar.framework.util.EnumerationIterator;

public class ClassLoaderUtil {
    private ClassLoaderUtil() {
    }

    public static ClassLoader getClassLoader(Object fallback) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader != null) {
            return loader;
        }
        if (fallback != null) {
            loader = fallback.getClass().getClassLoader();
        }
        if (loader != null) {
            return loader;
        }
        loader = ClassLoaderUtil.class.getClassLoader();
        if (loader != null) {
            return loader;
        }
        throw new IllegalStateException("class loader");
    }

    public static Iterator getResources(ClassLoader loader, String path) {
        try {
            Enumeration<URL> e = loader.getResources(path);
            return new EnumerationIterator(e);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }
}

