/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.cooldeploy.creator;

import org.seasar.framework.container.AutoBindingDef;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.InstanceDef;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.autoregister.ComponentCustomizer;
import org.seasar.framework.container.cooldeploy.CoolCreator;
import org.seasar.framework.container.factory.AnnotationHandler;
import org.seasar.framework.container.factory.AnnotationHandlerFactory;
import org.seasar.framework.convention.NamingConvention;
import org.seasar.framework.exception.EmptyRuntimeException;
import org.seasar.framework.util.ClassUtil;
import org.seasar.framework.util.ResourceUtil;

public abstract class AbstractCoolCreator
implements CoolCreator {
    private NamingConvention namingConvention;
    public static final String instanceDef_BINDING = "bindingType=may";
    private InstanceDef instanceDef;
    public static final String autoBindingDef_BINDING = "bindingType=may";
    private AutoBindingDef autoBindingDef;
    private boolean externalBinding = false;
    private String nameSuffix;
    private ComponentCustomizer customizer;
    private S2Container container;

    public AbstractCoolCreator(NamingConvention namingConvention) {
        if (namingConvention == null) {
            throw new EmptyRuntimeException("namingConvetion");
        }
        this.namingConvention = namingConvention;
    }

    public NamingConvention getNamingConvention() {
        return this.namingConvention;
    }

    public InstanceDef getInstanceDef() {
        return this.instanceDef;
    }

    public void setInstanceDef(InstanceDef instanceDef) {
        this.instanceDef = instanceDef;
    }

    public AutoBindingDef getAutoBindingDef() {
        return this.autoBindingDef;
    }

    public void setAutoBindingDef(AutoBindingDef autoBindingDef) {
        this.autoBindingDef = autoBindingDef;
    }

    public boolean isExternalBinding() {
        return this.externalBinding;
    }

    public void setExternalBinding(boolean externalBinding) {
        this.externalBinding = externalBinding;
    }

    public String getNameSuffix() {
        return this.nameSuffix;
    }

    public void setNameSuffix(String nameSuffix) {
        this.nameSuffix = nameSuffix;
    }

    protected ComponentCustomizer getCustomizer() {
        return this.customizer;
    }

    protected void setCustomizer(ComponentCustomizer customizer) {
        this.customizer = customizer;
    }

    public S2Container getContainer() {
        return this.container;
    }

    public void setContainer(S2Container container) {
        this.container = container;
    }

    public boolean loadComponentDef(String rootPackageName, Class clazz) {
        if (!this.isTargetClassName(rootPackageName, clazz.getName())) {
            return false;
        }
        Class targetClass = this.getTargetClass(clazz);
        if (targetClass == null) {
            return true;
        }
        AnnotationHandler handler = AnnotationHandlerFactory.getAnnotationHandler();
        ComponentDef cd = handler.createComponentDef(targetClass, this.instanceDef, this.autoBindingDef, this.externalBinding);
        if (cd.getComponentName() == null) {
            cd.setComponentName(this.composeComponentName(clazz.getName()));
        }
        handler.appendDI(cd);
        handler.appendAspect(cd);
        handler.appendInitMethod(cd);
        this.customize(cd);
        this.container.register(cd);
        return true;
    }

    protected boolean isTargetClassName(String rootPackageName, String className) {
        return this.isTargetMiddlePackage(rootPackageName, className) && this.isAppliedSuffix(className);
    }

    protected abstract boolean isTargetMiddlePackage(String var1, String var2);

    protected String composeComponentName(String className) {
        return this.getNamingConvention().fromClassNameToComponentName(className);
    }

    protected boolean isAppliedSuffix(String name) {
        if (this.nameSuffix != null) {
            return name.endsWith(this.nameSuffix);
        }
        return true;
    }

    protected Class getTargetClass(Class clazz) {
        if (!clazz.isInterface()) {
            return clazz;
        }
        String packageName = ClassUtil.getPackageName(clazz);
        String targetClassName = packageName + "." + this.getNamingConvention().getImplementationPackageName() + "." + ClassUtil.getShortClassName(clazz) + this.getNamingConvention().getImplementationSuffix();
        if (ResourceUtil.getResourceNoException(ClassUtil.getResourcePath(targetClassName)) != null) {
            return ClassUtil.forName(targetClassName);
        }
        return clazz;
    }

    protected void customize(ComponentDef componentDef) {
        if (this.customizer != null) {
            this.customizer.customize(componentDef);
        }
    }
}

