/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.hotdeploy.impl;

import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.autoregister.AbstractAutoRegisterProject;
import org.seasar.framework.container.hotdeploy.OndemandCreator;
import org.seasar.framework.container.hotdeploy.OndemandProject;
import org.seasar.framework.container.hotdeploy.OndemandS2Container;
import org.seasar.framework.exception.ClassNotFoundRuntimeException;

public class OndemandProjectImpl
extends AbstractAutoRegisterProject
implements OndemandProject {
    private OndemandCreator[] creators = new OndemandCreator[0];

    public OndemandCreator[] getCreators() {
        return this.creators;
    }

    public void setCreators(OndemandCreator[] creators) {
        this.creators = creators;
    }

    public boolean loadComponentDef(OndemandS2Container container, Class clazz) {
        for (int i = 0; i < this.creators.length; ++i) {
            OndemandCreator creator = this.creators[i];
            if (!creator.loadComponentDef(container, this.getRootPackageName(), clazz)) continue;
            return true;
        }
        return false;
    }

    public ComponentDef getComponentDef(OndemandS2Container container, Class clazz) {
        for (int i = 0; i < this.creators.length; ++i) {
            OndemandCreator creator = this.creators[i];
            ComponentDef cd = creator.getComponentDef(container, this.getRootPackageName(), clazz);
            if (cd == null) continue;
            return cd;
        }
        return null;
    }

    public ComponentDef getComponentDef(OndemandS2Container container, String componentName) {
        for (int i = 0; i < this.creators.length; ++i) {
            OndemandCreator creator = this.creators[i];
            try {
                ComponentDef cd = creator.getComponentDef(container, this.getRootPackageName(), componentName);
                if (cd == null) continue;
                return cd;
            }
            catch (ClassNotFoundRuntimeException ignore) {
                // empty catch block
            }
        }
        return null;
    }

    public String fromComponentNameToClassName(OndemandS2Container container, String componentName) {
        if (componentName == null) {
            return null;
        }
        for (int i = 0; i < this.creators.length; ++i) {
            OndemandCreator creator = this.creators[i];
            try {
                ComponentDef cd = creator.getComponentDef(container, this.getRootPackageName(), componentName);
                if (cd == null) continue;
                return cd.getComponentClass().getName();
            }
            catch (ClassNotFoundRuntimeException ex) {
                return ex.getClassName();
            }
        }
        return null;
    }
}

