<%@ page contentType="text/html; charset=UTF-8"%>
<%@ taglib uri="http://java.sun.com/jsf/html" prefix="h"%>
<%@ taglib uri="http://java.sun.com/jsf/core" prefix="f"%>
<%@ taglib uri="http://myfaces.apache.org/tomahawk" prefix="t"%>

<f:view>
	<f:loadBundle basename="jp.sf.pal.notepad.resources.NotepadResources"
		var="msgs" />

	<!-- Menu -->
	<f:subview id="menu">
		<jsp:include page="Menubar.jsp" />
	</f:subview>

	<h:form>
		<h:messages styleClass="portlet-msg-success"
			errorClass="portlet-msg-error" fatalClass="portlet-msg-error"
			warnClass="portlet-msg-alert" infoClass="portlet-msg-info" />

		<h:panelGrid columns="3">
			<h:outputLabel for="name">
				<h:outputText value="#{msgs['notepadaddpage.Name']}" />
			</h:outputLabel>
			<h:inputText id="name" value="#{notepadAddPage.name}" maxlength="255" />
			<h:message for="name"></h:message>

			<h:outputLabel for="permission">
				<h:outputText value="#{msgs['notepadaddpage.Permission']}" />
			</h:outputLabel>
			<h:selectOneMenu id="permission" value="#{notepadAddPage.permission}">
				<f:selectItems value="#{notepadAddPage.permissionItems}" />
			</h:selectOneMenu>
			<h:message for="permission"></h:message>

		</h:panelGrid>
		<h:panelGrid columns="1">

			<h:panelGroup>
				<h:outputLabel for="content">
					<h:outputText value="#{msgs['notepadaddpage.Content']}" />
				</h:outputLabel>
				<h:message for="content"></h:message>
			</h:panelGroup>

			<!-- Contents -->
			<h:inputTextarea id="content" value="#{notepadAddPage.content}"
				cols="80" rows="30" />

		</h:panelGrid>

		<h:panelGrid columns="2">
			<h:commandButton action="#{notepadAddPage.save}" value="#{msgs['notepadaddpage.Add']}" />
			<h:commandButton action="#{notepadAddPage.back}" value="#{msgs['notepadaddpage.Back']}"
				immediate="true" />
		</h:panelGrid>
	</h:form>

</f:view>
