/*
 * Copyright 2005-2006 The Portal Application Laboratory Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package jp.sf.pal.vfs.util;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.portlet.util.PortletConfigUtil;

public class VFSConfigUtil
{
    /**
     * Logger for this class
     */
    private static final Log log = LogFactory.getLog(VFSConfigUtil.class);

    private static String DEFAULT_URI = "default-uri";

    private static String ACCEPT_PATHS = "accept-paths";

    private static String DENY_PATHS = "deny-paths";

    private static String loadConfig(String key)
    {
        return PortletConfigUtil.getInitParameter(key);
    }

    public static boolean checkPath(String path)
    {
        String acceptPaths[] = getAcceptPaths();
        String denyPaths[] = getDenyPaths();
        if (acceptPaths.length > 0)
        {
            for (int i = 0; i < acceptPaths.length; i++)
            {
                if (path.matches(acceptPaths[i]))
                {
                    return true;
                }
            }
            return false;
        }
        else
        {
            if (denyPaths.length > 0)
            {
                for (int i = 0; i < denyPaths.length; i++)
                {
                    if (path.matches(denyPaths[i]))
                    {
                        return false;
                    }
                }
                return true;
            }
            else
            {
                // accept-paths and deny-paths are not defined
                return true;
            }
        }
    }

    /**
     * @return Returns the acceptPath.
     */
    public static String[] getAcceptPaths()
    {
        String acceptPathString = loadConfig(ACCEPT_PATHS);
        if (acceptPathString == null)
        {
            return new String[0];
        }
        else
        {
            return acceptPathString.split(",");
        }
    }

    /**
     * @return Returns the defualtUrl.
     */
    public static String getDefaultUri()
    {
        String defaultUri = loadConfig(DEFAULT_URI);
        if (defaultUri == null)
        {
            defaultUri = "file:///";
        }
        return defaultUri;
    }

    /**
     * @return Returns the denyPaths.
     */
    public static String[] getDenyPaths()
    {
        String denyPathString = loadConfig(DENY_PATHS);
        if (denyPathString == null)
        {
            return new String[0];
        }
        else
        {
            return denyPathString.split(",");
        }
    }

}
