/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.pal.tomahawk.filter;

import java.io.IOException;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jp.sf.pal.tomahawk.multipart.MultipartPortletRequestWrapper;
import jp.sf.pal.tomahawk.resourcehandler.ResourceHandler;
import jp.sf.pal.tomahawk.resourcehandler.ResourceHandlerFactory;
import jp.sf.pal.tomahawk.wrapper.HttpServletRequestWrapper;
import jp.sf.pal.tomahawk.wrapper.HttpServletResponseWrapper;
import org.apache.commons.fileupload.portlet.PortletFileUpload;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.renderkit.html.util.AddResource;
import org.apache.myfaces.renderkit.html.util.AddResourceFactory;
import org.apache.myfaces.webapp.filter.ExtensionsResponseWrapper;
import org.apache.portals.bridges.portletfilter.PortletFilter;
import org.apache.portals.bridges.portletfilter.PortletFilterChain;
import org.apache.portals.bridges.portletfilter.PortletFilterConfig;

public class ExtensionsPortletFilter
implements PortletFilter {
    private static final Log log = LogFactory.getLog((Class)ExtensionsPortletFilter.class);
    private static final String UPLOAD_REPOSITORY_PATH = "uploadRepositoryPath";
    private static final String UPLOAD_THRESHOLD_SIZE = "uploadThresholdSize";
    private static final String UPLOAD_MAX_FILE_SIZE = "uploadMaxFileSize";
    private int uploadMaxFileSize = 0x6400000;
    private int uploadThresholdSize = 0x100000;
    private String uploadRepositoryPath = null;
    private ResourceHandler resourceHandler;
    private PortletConfig portletConfig;

    public void init(PortletFilterConfig filterConfig) throws PortletException {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Initializing ExtensionsPortletFilter.");
        }
        this.setPortletConfig(filterConfig.getPortletConfig());
        this.resourceHandler = ResourceHandlerFactory.getHeaderResource(this.getPortletConfig().getPortletContext());
        if (this.resourceHandler == null) {
            log.error((Object)"resourceHandler is null. This portlet cannot probably put some tags into <head> element.");
        }
        String param = filterConfig.getInitParameter(UPLOAD_MAX_FILE_SIZE);
        this.uploadMaxFileSize = this.resolveSize(param, this.uploadMaxFileSize);
        param = filterConfig.getInitParameter(UPLOAD_THRESHOLD_SIZE);
        this.uploadThresholdSize = this.resolveSize(param, this.uploadThresholdSize);
        this.uploadRepositoryPath = filterConfig.getInitParameter(UPLOAD_REPOSITORY_PATH);
        if (log.isTraceEnabled()) {
            log.trace((Object)("uploadMaxFileSize=" + this.uploadMaxFileSize));
            log.trace((Object)("uploadThresholdSize=" + this.uploadThresholdSize));
            log.trace((Object)("uploadRepositoryPath=" + this.uploadRepositoryPath));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderFilter(RenderRequest request, RenderResponse response, PortletFilterChain chain) throws PortletException, IOException {
        if (log.isTraceEnabled()) {
            log.trace((Object)"called renderFilter.");
        }
        if (this.resourceHandler == null) {
            chain.renderFilter(request, response);
        } else {
            if (request.getAttribute("org.apache.myfaces.component.html.util.ExtensionFilter.doFilterCalled") != null) {
                chain.renderFilter(request, response);
                return;
            }
            request.setAttribute("org.apache.myfaces.component.html.util.ExtensionFilter.doFilterCalled", (Object)"true");
            HttpServletRequestWrapper extendedRequest = new HttpServletRequestWrapper((PortletRequest)request, this.getPortletConfig().getPortletContext());
            AddResource addResource = null;
            try {
                addResource = AddResourceFactory.getInstance((HttpServletRequest)extendedRequest);
            }
            catch (Throwable th) {
                log.error((Object)"Exception while retrieving addResource", th);
                throw new PortletException(th);
            }
            try {
                addResource.responseStarted();
                if (addResource.requiresBuffer()) {
                    RenderResponse extendedRenderResponse = response;
                    HttpServletResponseWrapper servletResponse = new HttpServletResponseWrapper(extendedRenderResponse);
                    ExtensionsResponseWrapper extendedResponse = new ExtensionsResponseWrapper((HttpServletResponse)servletResponse);
                    chain.renderFilter(request, extendedRenderResponse);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("renderFilter 0 " + extendedResponse.getContentType()));
                        log.debug((Object)("renderFilter 1 " + extendedResponse.toString()));
                    }
                    addResource.parseResponse((HttpServletRequest)extendedRequest, ResourceHandler.HTML_CONTENTS, (HttpServletResponse)servletResponse);
                    addResource.writeMyFacesJavascriptBeforeBodyEnd((HttpServletRequest)extendedRequest, (HttpServletResponse)servletResponse);
                    addResource.writeWithFullHeader((HttpServletRequest)extendedRequest, (HttpServletResponse)extendedResponse);
                    addResource.writeResponse((HttpServletRequest)extendedRequest, (HttpServletResponse)extendedResponse);
                    extendedResponse.finishResponse();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("renderFilter 12 " + extendedResponse.toString()));
                    }
                    this.resourceHandler.parse(extendedResponse.toString());
                    this.resourceHandler.addResourcesToHead(request, response);
                    this.resourceHandler.renderResourcesBeforeContents(request, response);
                    this.resourceHandler.renderResourcesAfterContents(request, response);
                    response.getWriter().flush();
                } else {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"renderFilter 3 ");
                    }
                    chain.renderFilter(request, response);
                }
            }
            finally {
                addResource.responseFinished();
            }
        }
    }

    public void processActionFilter(ActionRequest request, ActionResponse response, PortletFilterChain chain) throws PortletException, IOException {
        if (log.isTraceEnabled()) {
            log.trace((Object)"called processActionFilter.");
        }
        if (PortletFileUpload.isMultipartContent((ActionRequest)request)) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"ActionRequest is multipart content.");
            }
            request = new MultipartPortletRequestWrapper(request, this.uploadMaxFileSize, this.uploadThresholdSize, this.uploadRepositoryPath);
        }
        chain.processActionFilter(request, response);
    }

    public void destroy() {
    }

    private int resolveSize(String param, int defaultValue) {
        int numberParam = defaultValue;
        if (param != null) {
            param = param.toLowerCase();
            int factor = 1;
            String number = param;
            if (param.endsWith("g")) {
                factor = 0x40000000;
                number = param.substring(0, param.length() - 1);
            } else if (param.endsWith("m")) {
                factor = 0x100000;
                number = param.substring(0, param.length() - 1);
            } else if (param.endsWith("k")) {
                factor = 1024;
                number = param.substring(0, param.length() - 1);
            }
            numberParam = Integer.parseInt(number) * factor;
        }
        return numberParam;
    }

    public PortletConfig getPortletConfig() {
        return this.portletConfig;
    }

    public void setPortletConfig(PortletConfig portletConfig) {
        this.portletConfig = portletConfig;
    }

    public boolean isValidContentType(String contentType) {
        return contentType.startsWith("text/html") || contentType.startsWith("text/xml") || contentType.startsWith("application/xhtml+xml") || contentType.startsWith("application/xml");
    }
}

