/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.pal.tomahawk.resourcehandler;

import java.util.Enumeration;
import java.util.ResourceBundle;
import javax.portlet.PortletContext;
import jp.sf.pal.tomahawk.resourcehandler.DefaultResourceHandler;
import jp.sf.pal.tomahawk.resourcehandler.ResourceHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ResourceHandlerFactory {
    private static final Log log = LogFactory.getLog((Class)ResourceHandlerFactory.class);
    private static String RESOURCE_BUNDLE_NAME = "jp.sf.pal.tomahawk.resourcehandler.resources.ContainerInfo";
    private static ResourceBundle bundle;
    private static final String PORTAL_NAME_PREFIX = "headerresource.portal.";
    private static final String CLASS_NAME_PREFIX = "headerresource.class.";

    public static ResourceHandler getHeaderResource(PortletContext context) {
        if (bundle != null) {
            String serverInfo = context.getServerInfo();
            Enumeration<String> e = bundle.getKeys();
            while (e.hasMoreElements()) {
                String key = e.nextElement();
                if (!key.startsWith(PORTAL_NAME_PREFIX) || !serverInfo.matches(bundle.getString(key))) continue;
                String classNameKey = new String(CLASS_NAME_PREFIX + key.substring(PORTAL_NAME_PREFIX.length()));
                try {
                    String className = bundle.getString(classNameKey);
                    if (className != null) {
                        Object obj;
                        Class<?> clazz = Class.forName(bundle.getString(classNameKey));
                        if (clazz == null || !((obj = clazz.newInstance()) instanceof ResourceHandler)) continue;
                        ResourceHandler resourceHandler = (ResourceHandler)obj;
                        resourceHandler.setPortletContext(context);
                        resourceHandler.init();
                        return resourceHandler;
                    }
                    log.warn((Object)("Could not find " + className));
                }
                catch (InstantiationException ie) {
                    log.warn((Object)("Instantiation Exception: " + classNameKey), (Throwable)ie);
                }
                catch (IllegalAccessException iae) {
                    log.warn((Object)("Illegal Access Exception: " + classNameKey), (Throwable)iae);
                }
                catch (ClassNotFoundException cnfe) {
                    log.warn((Object)("Class Not Found: " + classNameKey), (Throwable)cnfe);
                }
            }
        }
        if (log.isInfoEnabled()) {
            log.info((Object)"Load a default resource handler.");
        }
        return ResourceHandlerFactory.getDefaultHeaderResource(context);
    }

    public static ResourceHandler getDefaultHeaderResource(PortletContext context) {
        DefaultResourceHandler resourceHandler = new DefaultResourceHandler();
        resourceHandler.setPortletContext(context);
        resourceHandler.init();
        return resourceHandler;
    }

    static {
        try {
            bundle = ResourceBundle.getBundle(RESOURCE_BUNDLE_NAME);
        }
        catch (Exception e) {
            log.warn((Object)("Could not find the resource bundole: " + RESOURCE_BUNDLE_NAME), (Throwable)e);
        }
    }
}

