/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.impl;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import org.seasar.extension.jdbc.ResultSetFactory;
import org.seasar.extension.jdbc.ResultSetHandler;
import org.seasar.extension.jdbc.SelectHandler;
import org.seasar.extension.jdbc.StatementFactory;
import org.seasar.extension.jdbc.impl.BasicHandler;
import org.seasar.extension.jdbc.impl.BasicResultSetFactory;
import org.seasar.extension.jdbc.impl.BasicStatementFactory;
import org.seasar.extension.jdbc.util.ConnectionUtil;
import org.seasar.framework.exception.EmptyRuntimeException;
import org.seasar.framework.exception.SQLRuntimeException;
import org.seasar.framework.log.Logger;
import org.seasar.framework.util.ResultSetUtil;
import org.seasar.framework.util.StatementUtil;

public class BasicSelectHandler
extends BasicHandler
implements SelectHandler {
    private static Logger logger_ = Logger.getLogger((Class)BasicSelectHandler.class);
    private ResultSetFactory resultSetFactory_ = BasicResultSetFactory.INSTANCE;
    private ResultSetHandler resultSetHandler_;
    private int fetchSize_ = 100;
    private int maxRows_ = -1;

    public BasicSelectHandler() {
    }

    public BasicSelectHandler(DataSource dataSource, String sql, ResultSetHandler resultSetHandler) {
        this(dataSource, sql, resultSetHandler, BasicStatementFactory.INSTANCE, BasicResultSetFactory.INSTANCE);
    }

    public BasicSelectHandler(DataSource dataSource, String sql, ResultSetHandler resultSetHandler, StatementFactory statementFactory, ResultSetFactory resultSetFactory) {
        this.setDataSource(dataSource);
        this.setSql(sql);
        this.setResultSetHandler(resultSetHandler);
        this.setStatementFactory(statementFactory);
        this.setResultSetFactory(resultSetFactory);
    }

    public ResultSetFactory getResultSetFactory() {
        return this.resultSetFactory_;
    }

    public void setResultSetFactory(ResultSetFactory resultSetFactory) {
        this.resultSetFactory_ = resultSetFactory;
    }

    public ResultSetHandler getResultSetHandler() {
        return this.resultSetHandler_;
    }

    public void setResultSetHandler(ResultSetHandler resultSetHandler) {
        this.resultSetHandler_ = resultSetHandler;
    }

    public int getFetchSize() {
        return this.fetchSize_;
    }

    public void setFetchSize(int fetchSize) {
        this.fetchSize_ = fetchSize;
    }

    public int getMaxRows() {
        return this.maxRows_;
    }

    public void setMaxRows(int maxRows) {
        this.maxRows_ = maxRows;
    }

    public Object execute(Object[] args) throws SQLRuntimeException {
        return this.execute(args, this.getArgTypes(args));
    }

    public Object execute(Object[] args, Class[] argTypes) throws SQLRuntimeException {
        if (logger_.isDebugEnabled()) {
            logger_.debug((Object)this.getCompleteSql(args));
        }
        Connection con = this.getConnection();
        try {
            Object object = this.execute(con, args, argTypes);
            return object;
        }
        catch (SQLException ex) {
            throw new SQLRuntimeException(ex);
        }
        finally {
            ConnectionUtil.close(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object execute(Connection connection, Object[] args, Class[] argTypes) throws SQLException {
        PreparedStatement ps = null;
        try {
            ps = this.prepareStatement(connection);
            this.bindArgs(ps, args, argTypes);
            Object object = this.execute(ps);
            return object;
        }
        finally {
            StatementUtil.close((Statement)ps);
        }
    }

    protected Object[] setup(Connection con, Object[] args) {
        return args;
    }

    protected PreparedStatement prepareStatement(Connection connection) {
        PreparedStatement ps = super.prepareStatement(connection);
        if (this.fetchSize_ > -1) {
            StatementUtil.setFetchSize((Statement)ps, (int)this.fetchSize_);
        }
        if (this.maxRows_ > -1) {
            StatementUtil.setMaxRows((Statement)ps, (int)this.maxRows_);
        }
        return ps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object execute(PreparedStatement ps) throws SQLException {
        if (this.resultSetHandler_ == null) {
            throw new EmptyRuntimeException("resultSetHandler");
        }
        ResultSet resultSet = null;
        try {
            resultSet = this.createResultSet(ps);
            Object object = this.resultSetHandler_.handle(resultSet);
            return object;
        }
        finally {
            ResultSetUtil.close((ResultSet)resultSet);
        }
    }

    protected void setupDatabaseMetaData(DatabaseMetaData dbMetaData) {
    }

    protected ResultSet createResultSet(PreparedStatement ps) {
        return this.resultSetFactory_.createResultSet(ps);
    }
}

