/*
 * Decompiled with CFR 0.152.
 */
package jcifs;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.StringTokenizer;
import jcifs.Config;
import jcifs.netbios.Lmhosts;
import jcifs.netbios.NbtAddress;
import jcifs.util.Log;

public class UniAddress {
    static final int RESOLVER_WINS = 0;
    static final int RESOLVER_BCAST = 1;
    static final int RESOLVER_DNS = 2;
    static final int RESOLVER_LMHOSTS = 3;
    static int[] resolveOrder;
    static InetAddress nbns;
    static InetAddress baddr;
    Object addr;
    String calledName;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static NbtAddress lookupServerOrWorkgroup(String name, InetAddress svr) throws UnknownHostException {
        Sem sem = new Sem(2);
        int type = svr == nbns ? 27 : 29;
        QueryThread q1x = new QueryThread(sem, name, type, null, svr);
        QueryThread q20 = new QueryThread(sem, name, 32, null, svr);
        q1x.setDaemon(true);
        q20.setDaemon(true);
        try {
            Sem sem2 = sem;
            synchronized (sem2) {
                q1x.start();
                q20.start();
                while (sem.count > 0 && q1x.ans == null && q20.ans == null) {
                    sem.wait();
                }
            }
        }
        catch (InterruptedException ie) {
            throw new UnknownHostException(name);
        }
        if (q1x.ans != null) {
            return q1x.ans;
        }
        if (q20.ans != null) {
            return q20.ans;
        }
        throw q1x.uhe;
    }

    public static UniAddress getByName(String hostname) throws UnknownHostException {
        return UniAddress.getByName(hostname, false);
    }

    static boolean isDotQuadIP(String hostname) {
        if (Character.isDigit(hostname.charAt(0))) {
            int dots = 0;
            int i = 0;
            int len = hostname.length();
            char[] data = hostname.toCharArray();
            while (i < len && Character.isDigit(data[i++])) {
                if (i == len && dots == 3) {
                    return true;
                }
                if (i >= len || data[i] != '.') continue;
                ++dots;
                ++i;
            }
        }
        return false;
    }

    static boolean isValidDnsName(String hostname) {
        return !Character.isDigit(hostname.charAt(0));
    }

    public static UniAddress getByName(String hostname, boolean possibleNTDomainOrWorkgroup) throws UnknownHostException {
        if (hostname == null || hostname.length() == 0) {
            throw new UnknownHostException();
        }
        if (UniAddress.isDotQuadIP(hostname)) {
            return new UniAddress(NbtAddress.getByName(hostname));
        }
        int i = 0;
        while (i < resolveOrder.length) {
            block16: {
                try {
                    Object addr;
                    switch (resolveOrder[i]) {
                        case 3: {
                            addr = Lmhosts.getByName(hostname);
                            if (addr != null) break;
                            break block16;
                        }
                        case 0: {
                            if (hostname != "\u0001\u0002__MSBROWSE__\u0002" && hostname.length() <= 15) {
                                if (possibleNTDomainOrWorkgroup) {
                                    addr = UniAddress.lookupServerOrWorkgroup(hostname, nbns);
                                    break;
                                }
                                addr = NbtAddress.getByName(hostname, 32, null, nbns);
                                break;
                            }
                            break block16;
                        }
                        case 1: {
                            if (hostname.length() <= 15) {
                                if (possibleNTDomainOrWorkgroup) {
                                    addr = UniAddress.lookupServerOrWorkgroup(hostname, baddr);
                                    break;
                                }
                                addr = NbtAddress.getByName(hostname, 32, null, baddr);
                                break;
                            }
                            break block16;
                        }
                        case 2: {
                            if (!UniAddress.isValidDnsName(hostname)) {
                                throw new UnknownHostException(hostname);
                            }
                            addr = InetAddress.getByName(hostname);
                            break;
                        }
                        default: {
                            throw new UnknownHostException(hostname);
                        }
                    }
                    return new UniAddress(addr);
                }
                catch (IOException ioe) {
                    // empty catch block
                }
            }
            ++i;
        }
        throw new UnknownHostException(hostname);
    }

    public UniAddress(Object addr) {
        if (addr == null) {
            throw new IllegalArgumentException();
        }
        this.addr = addr;
    }

    public int hashCode() {
        return this.addr.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof UniAddress && this.addr.hashCode() == obj.hashCode();
    }

    public String firstCalledName() {
        int i;
        if (this.addr instanceof NbtAddress) {
            return ((NbtAddress)this.addr).firstCalledName();
        }
        this.calledName = ((InetAddress)this.addr).getHostName();
        this.calledName = UniAddress.isDotQuadIP(this.calledName) ? "*SMBSERVER     " : ((i = this.calledName.indexOf(46)) > 1 && i < 15 ? this.calledName.substring(0, i).toUpperCase() : (this.calledName.length() > 15 ? "*SMBSERVER     " : this.calledName.toUpperCase()));
        return this.calledName;
    }

    public String nextCalledName() {
        if (this.addr instanceof NbtAddress) {
            return ((NbtAddress)this.addr).nextCalledName();
        }
        if (this.calledName != "*SMBSERVER     ") {
            this.calledName = "*SMBSERVER     ";
            return this.calledName;
        }
        return null;
    }

    public Object getAddress() {
        return this.addr;
    }

    public String getHostName() {
        if (this.addr instanceof NbtAddress) {
            return ((NbtAddress)this.addr).getHostName();
        }
        return ((InetAddress)this.addr).getHostName();
    }

    public String getHostAddress() {
        if (this.addr instanceof NbtAddress) {
            return ((NbtAddress)this.addr).getHostAddress();
        }
        return ((InetAddress)this.addr).getHostAddress();
    }

    public String toString() {
        return this.addr.toString();
    }

    static {
        String ro = Config.getProperty("jcifs.resolveOrder");
        nbns = Config.getInetAddress("jcifs.netbios.wins", null);
        try {
            baddr = Config.getInetAddress("jcifs.netbios.baddr", InetAddress.getByName("255.255.255.255"));
        }
        catch (UnknownHostException uhe) {
            // empty catch block
        }
        if (ro == null || ro.length() == 0) {
            if (nbns == null) {
                resolveOrder = new int[3];
                UniAddress.resolveOrder[0] = 3;
                UniAddress.resolveOrder[1] = 1;
                UniAddress.resolveOrder[2] = 2;
            } else {
                resolveOrder = new int[4];
                UniAddress.resolveOrder[0] = 3;
                UniAddress.resolveOrder[1] = 0;
                UniAddress.resolveOrder[2] = 1;
                UniAddress.resolveOrder[3] = 2;
            }
        } else {
            int[] tmp = new int[4];
            StringTokenizer st = new StringTokenizer(ro, ",");
            int i = 0;
            while (st.hasMoreTokens()) {
                String s = st.nextToken().trim();
                if (s.equalsIgnoreCase("LMHOSTS")) {
                    tmp[i++] = 3;
                    continue;
                }
                if (s.equalsIgnoreCase("WINS")) {
                    if (nbns == null) {
                        Log.println(2, "netbios name service warning", " resolveOrder specifies WINS however the jcifs.netbios.wins property has not been set");
                        continue;
                    }
                    tmp[i++] = 0;
                    continue;
                }
                if (s.equalsIgnoreCase("BCAST")) {
                    tmp[i++] = 1;
                    continue;
                }
                if (s.equalsIgnoreCase("DNS")) {
                    tmp[i++] = 2;
                    continue;
                }
                Log.println(2, "netbios name service warning", "unknown resolver method: " + s);
            }
            resolveOrder = new int[i];
            System.arraycopy(tmp, 0, resolveOrder, 0, i);
        }
    }

    static class QueryThread
    extends Thread {
        Sem sem;
        String host;
        String scope;
        int type;
        NbtAddress ans = null;
        InetAddress svr;
        UnknownHostException uhe;

        QueryThread(Sem sem, String host, int type, String scope, InetAddress svr) {
            super("JCIFS-QueryThread: " + host);
            this.sem = sem;
            this.host = host;
            this.type = type;
            this.scope = scope;
            this.svr = svr;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                this.ans = NbtAddress.getByName(this.host, this.type, this.scope, this.svr);
            }
            catch (UnknownHostException uhe) {
                this.uhe = uhe;
            }
            catch (Exception ex) {
                this.uhe = new UnknownHostException(ex.getMessage());
            }
            finally {
                Sem sem = this.sem;
                synchronized (sem) {
                    --this.sem.count;
                    this.sem.notify();
                }
            }
        }
    }

    static class Sem {
        int count;

        Sem(int count) {
            this.count = count;
        }
    }
}

